/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.util.MapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexUtil.class);
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();

    private RegexUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean matches(String regexPattern, CharSequence input) {
        Validate.notNull(regexPattern, "regexPattern can't be null!", new Object[0]);
        if (null == input) {
            return false;
        }
        return RegexUtil.getMatcher(regexPattern, input).matches();
    }

    public static Map<Integer, String> group(String regexPattern, CharSequence input) {
        Matcher matcher = RegexUtil.getMatcher(regexPattern, input);
        if (!matcher.matches()) {
            LOGGER.trace("[not matches] ,\n\tregexPattern:[{}] \n\tinput:[{}]", (Object)regexPattern, (Object)input);
            return Collections.emptyMap();
        }
        int groupCount = matcher.groupCount();
        Map<Integer, String> map = MapUtil.newLinkedHashMap(groupCount + 1);
        for (int i = 0; i <= groupCount; ++i) {
            String groupValue = matcher.group(i);
            LOGGER.trace("matcher group[{}],start-end:[{}-{}],groupValue:[{}]", new Object[]{i, matcher.start(i), matcher.end(i), groupValue});
            map.put(i, groupValue);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("regexPattern:[{}],input:[{}],groupMap:{}", new Object[]{regexPattern, input, map});
        }
        return map;
    }

    public static String group(String regexPattern, CharSequence input, int groupNo) {
        Validate.isTrue(groupNo >= 0, "groupNo must >=0", new Object[0]);
        Map<Integer, String> map = RegexUtil.group(regexPattern, input);
        return map.get(groupNo);
    }

    private static Matcher getMatcher(String regexPattern, CharSequence input) {
        return RegexUtil.getMatcher(regexPattern, input, 0);
    }

    private static Matcher getMatcher(String regexPattern, CharSequence input, int flags) {
        Validate.notNull(regexPattern, "regexPattern can't be null!", new Object[0]);
        Validate.notNull(input, "input can't be null!", new Object[0]);
        Pattern pattern = RegexUtil.buildPattern(regexPattern, flags);
        return pattern.matcher(input);
    }

    public static Pattern buildPattern(String regexPattern, int flags) {
        String key = regexPattern + "@" + flags;
        Pattern pattern = PATTERN_CACHE.get(key);
        if (null == pattern) {
            pattern = Pattern.compile(regexPattern, flags);
            PATTERN_CACHE.put(key, pattern);
        }
        return pattern;
    }
}

