/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.lib.lang3.RandomStringUtils;
import java.util.Random;

public final class RandomUtil {
    private static final Random JVM_RANDOM = new Random();

    private RandomUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static long createRandomWithLength(int length) {
        Validate.isTrue(length > 0, "input param [length] must >0,but is [%s]", length);
        long num = 1L;
        for (int i = 0; i < length; ++i) {
            num *= 10L;
        }
        double random = JVM_RANDOM.nextDouble();
        random = random < 0.1 ? random + 0.1 : random;
        return (long)(random * (double)num);
    }

    public static String createRandomFromString(String str, int length) {
        Validate.notBlank(str, "str can't be null/empty!", new Object[0]);
        Validate.isTrue(length > 0, "input param [length] must >0,but is [%s]", length);
        return RandomStringUtils.random(length, str);
    }

    public static String createRandomString(int length) {
        Validate.isTrue(length > 0, "input param [length] must >0,but is [%s]", length);
        return RandomStringUtils.random(length, "23456789abcdefghijkmnpqrstuvwxyz");
    }
}

