/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.net;

import com.feilong.core.Validate;
import com.feilong.core.net.URIParseException;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLUtil.class);

    private URLUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static URL toURL(String spec) {
        Validate.notBlank(spec, "spec can't be blank!", new Object[0]);
        try {
            return new URL(spec);
        }
        catch (Exception e) {
            LOGGER.trace("[new URL(\"{}\")] exception,cause by :[{}],will try call [toFileURL(\"{}\")]", new Object[]{spec, e.getMessage(), spec});
            return URLUtil.toFileURL(spec);
        }
    }

    private static URL toFileURL(String filePath) {
        try {
            return new File(filePath).toURI().toURL();
        }
        catch (Exception e) {
            throw new URIParseException(Slf4jUtil.format("filePath:[{}]", filePath), e);
        }
    }

    public static URI toURI(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new URIParseException(Slf4jUtil.format("input url:[{}]", url), e);
        }
    }

    public static InputStream openStream(URL url) {
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(Slf4jUtil.format("openStream url:[{}]", url), e);
        }
    }

    public static String getUnionUrl(URL context, String spec) {
        Validate.notBlank(spec, "spec can't be null!", new Object[0]);
        try {
            return new URL(context, spec).toString();
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("context:[{}],spec:[{}]", context, spec);
            throw new URIParseException(message, e);
        }
    }
}

