/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.reflect;

import com.feilong.core.Validate;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.reflect.ReflectException;
import com.feilong.lib.lang3.reflect.MethodUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodUtil.class);

    private MethodUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... params) {
        Validate.notNull(obj, "obj can't be null!", new Object[0]);
        Validate.notBlank(methodName, "methodName can't be blank!", new Object[0]);
        Class<?>[] parameterTypes = ClassUtil.toClass(params);
        return MethodUtil.invokeMethod(obj, methodName, params, parameterTypes);
    }

    public static <T> T invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Validate.notNull(object, "object can't be null!", new Object[0]);
        Validate.notBlank(methodName, "methodName can't be blank!", new Object[0]);
        try {
            return (T)MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
        }
        catch (Exception e) {
            String pattern = "invokeMethod Exception,object:[{}],methodName:[{}],args:[{}],parameterTypes:[{}]";
            String message = Slf4jUtil.format(pattern, object, methodName, args, parameterTypes);
            throw new ReflectException(message, e);
        }
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String staticMethodName, Object ... params) {
        Class<?>[] parameterTypes = ClassUtil.toClass(params);
        return MethodUtil.invokeStaticMethod(klass, staticMethodName, params, parameterTypes);
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String staticMethodName, Object[] args, Class<?>[] parameterTypes) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        Validate.notBlank(staticMethodName, "staticMethodName can't be blank!", new Object[0]);
        try {
            return (T)MethodUtils.invokeStaticMethod(klass, staticMethodName, args, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            LOGGER.trace("from class:[{}],can't find [public static {}()] method,cause exception: [{}],will try to find [private static] method", new Object[]{klass.getSimpleName(), staticMethodName, e});
            return MethodUtil.doWithNoSuchMethodException(klass, staticMethodName, args, parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectException(MethodUtil.buildMessage(klass, staticMethodName, args, parameterTypes), e);
        }
    }

    private static <T> T doWithNoSuchMethodException(Class<?> klass, String staticMethodName, Object[] args, Class<?>[] parameterTypes) {
        try {
            Method matchingMethod = MethodUtils.getMatchingMethod(klass, staticMethodName, parameterTypes);
            if (null == matchingMethod) {
                throw new NoSuchMethodException("No such method:[" + staticMethodName + "()] on class: " + klass.getName());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("bingo,from class:[{}],find name [{}] method", (Object)klass.getSimpleName(), (Object)staticMethodName);
            }
            matchingMethod.setAccessible(true);
            return (T)matchingMethod.invoke(null, args);
        }
        catch (Exception e) {
            throw new ReflectException(MethodUtil.buildMessage(klass, staticMethodName, args, parameterTypes), e);
        }
    }

    private static String buildMessage(Class<?> klass, String staticMethodName, Object[] args, Class<?>[] parameterTypes) {
        String pattern = "invokeStaticMethod Exception,class:[{}],staticMethodName:[{}],args:[{}],parameterTypes:[{}]";
        return Slf4jUtil.format(pattern, klass.getName(), staticMethodName, args, parameterTypes);
    }
}

