/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.reflect;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.reflect.ReflectException;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.predicate.BeanPredicateUtil;
import com.feilong.lib.collection4.PredicateUtils;
import com.feilong.lib.lang3.reflect.FieldUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldUtil.class);

    private FieldUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Map<String, Object> getAllFieldNameAndValueMap(Object obj, String ... excludeFieldNames) {
        Validate.notNull(obj, "obj can't be null!", new Object[0]);
        List<Field> fieldList = FieldUtil.getAllFieldList(obj.getClass(), excludeFieldNames);
        if (Validator.isNullOrEmpty(fieldList)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Field field : fieldList) {
            map.put(field.getName(), FieldUtil.getFieldValue(obj, field.getName()));
        }
        return map;
    }

    public static List<Field> getAllFieldList(final Class<?> klass, String ... excludeFieldNames) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        List<Field> fieldList = FieldUtils.getAllFieldsList(klass);
        if (Validator.isNullOrEmpty(fieldList)) {
            return Collections.emptyList();
        }
        Predicate excludeFieldPredicate = BeanPredicateUtil.containsPredicate("name", excludeFieldNames);
        Predicate<Field> staticPredicate = new Predicate<Field>(){

            @Override
            public boolean evaluate(Field field) {
                int modifiers = field.getModifiers();
                boolean isStatic = Modifier.isStatic(modifiers);
                String pattern = "[{}.{}],modifiers:[{}]{}";
                LOGGER.trace(pattern, new Object[]{klass.getSimpleName(), field.getName(), modifiers, isStatic ? " [isStatic]" : ""});
                return isStatic;
            }
        };
        return CollectionsUtil.selectRejected(fieldList, PredicateUtils.orPredicate(excludeFieldPredicate, staticPredicate));
    }

    private static <T> T getFieldValue(Object obj, String fieldName) {
        try {
            return (T)FieldUtils.readField(obj, fieldName, true);
        }
        catch (Exception e) {
            String pattern = "getFieldValue exception,ownerObj:[{}],fieldName:[{}]";
            throw new ReflectException(Slf4jUtil.format(pattern, obj, fieldName), e);
        }
    }
}

