/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import java.lang.reflect.Array;

public final class ArrayUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private ArrayUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T getElement(Object array, int index) {
        Validate.notNull(array, "array can't be null!", new Object[0]);
        return (T)Array.get(array, index);
    }

    public static <T> T[] newArray(Class<T> componentType, int length) {
        Validate.notNull(componentType, "componentType can't be null!", new Object[0]);
        Validate.isTrue(length >= 0, "length:[%s],must >=0", length);
        return (Object[])Array.newInstance(componentType, length);
    }
}

