/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ToStringConfig;
import com.feilong.core.bean.ToStringHandler;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.core.util.transformer.SimpleClassTransformer;
import com.feilong.lib.beanutils.ConvertUtils;
import com.feilong.lib.beanutils.converters.BigDecimalConverter;
import com.feilong.lib.beanutils.converters.BigIntegerConverter;
import com.feilong.lib.beanutils.converters.BooleanConverter;
import com.feilong.lib.beanutils.converters.ByteConverter;
import com.feilong.lib.beanutils.converters.CharacterConverter;
import com.feilong.lib.beanutils.converters.DoubleConverter;
import com.feilong.lib.beanutils.converters.FloatConverter;
import com.feilong.lib.beanutils.converters.IntegerConverter;
import com.feilong.lib.beanutils.converters.LongConverter;
import com.feilong.lib.beanutils.converters.ShortConverter;
import com.feilong.lib.beanutils.converters.StringConverter;
import com.feilong.lib.beanutils.locale.converters.DateLocaleConverter;
import com.feilong.lib.collection4.IteratorUtils;
import com.feilong.lib.collection4.MapUtils;
import com.feilong.lib.lang3.ArrayUtils;
import com.feilong.lib.lang3.LocaleUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.Transformer;

public final class ConvertUtil {
    private ConvertUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void registerStandardDefaultNull() {
        ConvertUtils.register(new BigDecimalConverter(null), BigDecimal.class);
        ConvertUtils.register(new BigIntegerConverter(null), BigInteger.class);
        ConvertUtils.register(new BooleanConverter(null), Boolean.class);
        ConvertUtils.register(new ByteConverter(null), Byte.class);
        ConvertUtils.register(new CharacterConverter(null), Character.class);
        ConvertUtils.register(new DoubleConverter(null), Double.class);
        ConvertUtils.register(new FloatConverter(null), Float.class);
        ConvertUtils.register(new IntegerConverter(null), Integer.class);
        ConvertUtils.register(new LongConverter(null), Long.class);
        ConvertUtils.register(new ShortConverter(null), Short.class);
        ConvertUtils.register(new StringConverter(null), String.class);
    }

    public static void registerSimpleDateLocaleConverter(String pattern) {
        DateLocaleConverter dateLocaleConverter = new DateLocaleConverter(null, Locale.getDefault(), pattern);
        ConvertUtils.register(dateLocaleConverter, Date.class);
    }

    public static Boolean toBoolean(Object toBeConvertedValue) {
        return new BooleanConverter(null).convert(Boolean.class, toBeConvertedValue);
    }

    public static Integer toInteger(Object toBeConvertedValue) {
        return ConvertUtil.toInteger(toBeConvertedValue, null);
    }

    public static Integer toInteger(Object toBeConvertedValue, Integer defaultValue) {
        return new IntegerConverter(defaultValue).convert(Integer.class, toBeConvertedValue);
    }

    public static Long toLong(Object toBeConvertedValue) {
        return new LongConverter(null).convert(Long.class, toBeConvertedValue);
    }

    public static BigDecimal toBigDecimal(Object toBeConvertedValue) {
        return new BigDecimalConverter(null).convert(BigDecimal.class, toBeConvertedValue);
    }

    public static Integer[] toIntegers(Object toBeConvertedValue) {
        return ConvertUtil.convert(toBeConvertedValue, Integer[].class);
    }

    public static Long[] toLongs(Object toBeConvertedValue) {
        return ConvertUtil.convert(toBeConvertedValue, Long[].class);
    }

    public static String toString(Object toBeConvertedValue) {
        return ToStringHandler.toStringValue(toBeConvertedValue);
    }

    public static String toString(Collection<?> collection, String connector) {
        return Validator.isNullOrEmpty(collection) ? "" : ConvertUtil.toString(collection.toArray(), new ToStringConfig(connector));
    }

    public static String toString(Object[] arrays, String connector) {
        return Validator.isNullOrEmpty(arrays) ? "" : ConvertUtil.toString(arrays, new ToStringConfig(connector));
    }

    public static String toString(Collection<?> collection, ToStringConfig toStringConfig) {
        return Validator.isNullOrEmpty(collection) ? "" : ConvertUtil.toString(collection.toArray(), toStringConfig);
    }

    public static String toString(Object[] arrays, ToStringConfig toStringConfig) {
        if (Validator.isNullOrEmpty(arrays)) {
            return "";
        }
        ToStringConfig useToStringConfig = ObjectUtil.defaultIfNull(toStringConfig, new ToStringConfig());
        String connector = useToStringConfig.getConnector();
        boolean isJoinNullOrEmpty = useToStringConfig.getIsJoinNullOrEmpty();
        String prefix = useToStringConfig.getPrefix();
        StringBuilder sb = new StringBuilder();
        for (Object element : arrays) {
            if (Validator.isNullOrEmpty(element) && !isJoinNullOrEmpty) continue;
            sb.append(ObjectUtil.defaultIfNull(prefix, ""));
            sb.append((Object)ObjectUtil.defaultIfNull(element, ""));
            if (null == connector) continue;
            sb.append(connector);
        }
        return StringUtil.substringWithoutLast(sb, connector);
    }

    public static <T> Enumeration<T> toEnumeration(Collection<T> collection) {
        return null == collection ? Collections.emptyEnumeration() : Collections.enumeration(collection);
    }

    public static <K, V> Map<K, V> toMap(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> toMap(K key1, V value1, K key2, V value2) {
        Map<K, V> map = ConvertUtil.toMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static Map<String, String> toMap(Properties properties) {
        if (Validator.isNullOrEmpty(properties)) {
            return Collections.emptyMap();
        }
        return SortUtil.sortMapByKeyAsc(properties);
    }

    public static <K, V, J> Map<K, J> toMap(Map<K, V> inputMap, Class<J> valueTargetType) {
        return ConvertUtil.toMap(inputMap, null, valueTargetType);
    }

    public static <K, V, I, J> Map<I, J> toMap(Map<K, V> inputMap, Class<I> keyTargetType, Class<J> valueTargetType) {
        if (Validator.isNullOrEmpty(inputMap)) {
            return Collections.emptyMap();
        }
        SimpleClassTransformer keyTransformer = null == keyTargetType ? null : new SimpleClassTransformer(keyTargetType);
        SimpleClassTransformer valueTransformer = null == valueTargetType ? null : new SimpleClassTransformer(valueTargetType);
        return ConvertUtil.toMap(inputMap, keyTransformer, valueTransformer);
    }

    public static <K, V, I, J> Map<I, J> toMap(Map<K, V> inputMap, Transformer<K, I> keyTransformer, Transformer<V, J> valueTransformer) {
        if (Validator.isNullOrEmpty(inputMap)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> returnMap = new LinkedHashMap<K, V>(inputMap.size());
        for (Map.Entry<K, V> entry : inputMap.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            returnMap.put(null == keyTransformer ? key : keyTransformer.transform(key), null == valueTransformer ? value : valueTransformer.transform(value));
        }
        return returnMap;
    }

    public static <V, K, E extends Map.Entry<K, V>> Map<K, V> toMap(Collection<E> mapEntryCollection) {
        if (null == mapEntryCollection) {
            return Collections.emptyMap();
        }
        Validate.noNullElements(mapEntryCollection, "mapEntryCollection can't has null elememt!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap(mapEntryCollection.size());
        for (Map.Entry entry : mapEntryCollection) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @SafeVarargs
    public static <V, K> Map<K, V> toMapUseEntrys(Map.Entry<K, V> ... mapEntrys) {
        if (null == mapEntrys) {
            return Collections.emptyMap();
        }
        Validate.noNullElements(mapEntrys, "mapEntrys can't has null elememt!", new Object[0]);
        Map<K, V> map = MapUtil.newLinkedHashMap(mapEntrys.length);
        for (Map.Entry<K, V> entry : mapEntrys) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static Properties toProperties(Map<String, String> map) {
        return MapUtils.toProperties(map);
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        return null == enumeration ? Collections.emptyList() : Collections.list(enumeration);
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (null == collection) {
            return Collections.emptyList();
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... arrays) {
        return Validator.isNullOrEmpty(arrays) ? Collections.emptyList() : new ArrayList<T>(Arrays.asList(arrays));
    }

    @SafeVarargs
    public static <T> Set<T> toSet(T ... arrays) {
        return Validator.isNullOrEmpty(arrays) ? Collections.emptySet() : new LinkedHashSet<T>(Arrays.asList(arrays));
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... arrays) {
        return ArrayUtils.toArray(arrays);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> arrayComponentType) {
        if (null == collection) {
            return null;
        }
        Validate.notNull(arrayComponentType, "arrayComponentType must not be null", new Object[0]);
        T[] array = ArrayUtil.newArray(arrayComponentType, collection.size());
        return collection.toArray(array);
    }

    public static <T> T[] toArray(String[] toBeConvertedValue, Class<T> targetType) {
        return null == toBeConvertedValue ? null : (Object[])ConvertUtils.convert(toBeConvertedValue, targetType);
    }

    public static String[] toStrings(Object toBeConvertedValue) {
        return ConvertUtil.convert(toBeConvertedValue, String[].class);
    }

    public static <T> Iterator<T> toIterator(Object toBeConvertedValue) {
        if (null == toBeConvertedValue) {
            return null;
        }
        if (toBeConvertedValue instanceof String) {
            return ConvertUtil.toIterator(ConvertUtil.toStrings(toBeConvertedValue));
        }
        return IteratorUtils.getIterator(toBeConvertedValue);
    }

    public static <T> T convert(Object toBeConvertedValue, Class<T> targetType) {
        Validate.notNull(targetType, "targetType can't be null!", new Object[0]);
        return (T)(null == toBeConvertedValue ? null : ConvertUtils.convert(toBeConvertedValue, targetType));
    }

    public static Locale toLocale(Object locale) {
        if (null == locale) {
            return null;
        }
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return LocaleUtils.toLocale((String)locale);
        }
        throw new UnsupportedOperationException("input param [locale] type is:[" + locale.getClass().getName() + "] not support!");
    }

    static {
        ConvertUtil.registerStandardDefaultNull();
    }
}

