/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.Alias;
import com.feilong.core.bean.BeanOperationException;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.beanutils.BeanUtils;
import com.feilong.lib.beanutils.LazyDynaBean;
import com.feilong.lib.lang3.reflect.FieldUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;

public final class BeanUtil {
    private BeanUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void copyProperties(Object toObj, Object fromObj, String ... includePropertyNames) {
        Validate.notNull(toObj, "toObj [destination bean] not specified!", new Object[0]);
        Validate.notNull(fromObj, "fromObj [origin bean] not specified!", new Object[0]);
        if (Validator.isNullOrEmpty(includePropertyNames)) {
            try {
                BeanUtils.copyProperties(toObj, fromObj);
                return;
            }
            catch (Exception e) {
                String pattern = "copyProperties exception,toObj:[{}],fromObj:[{}],includePropertyNames:[{}]";
                throw new BeanOperationException(Slf4jUtil.format(pattern, toObj, fromObj, includePropertyNames), e);
            }
        }
        for (String propertyName : includePropertyNames) {
            String value = BeanUtil.getProperty(fromObj, propertyName);
            BeanUtil.setProperty(toObj, propertyName, value);
        }
    }

    private static void setProperty(Object bean, String propertyName, Object value) {
        try {
            BeanUtils.setProperty(bean, propertyName, value);
        }
        catch (Exception e) {
            String pattern = "setProperty exception,bean:[{}],propertyName:[{}],value:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyName, value), e);
        }
    }

    private static String getProperty(Object bean, String propertyName) {
        Validate.notNull(bean, "bean can't be null!", new Object[0]);
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        try {
            return BeanUtils.getProperty(bean, propertyName);
        }
        catch (Exception e) {
            String pattern = "getProperty exception,bean:[{}],propertyName:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyName), e);
        }
    }

    public static <T> T cloneBean(T bean) {
        Validate.notNull(bean, "bean can't be null!", new Object[0]);
        try {
            return (T)BeanUtils.cloneBean(bean);
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("cloneBean exception,bean:[{}]]", bean);
            throw new BeanOperationException(message, e);
        }
    }

    public static <T> T populate(T bean, Map<String, ?> properties) {
        Validate.notNull(bean, "bean can't be null/empty!", new Object[0]);
        Validate.notNull(properties, "properties can't be null/empty!", new Object[0]);
        try {
            BeanUtils.populate(bean, properties);
            return bean;
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("can't populate:[{}] to bean:{}", properties, bean);
            throw new BeanOperationException(message, e);
        }
    }

    public static <T> T populateAliasBean(T aliasBean, Map<String, ?> aliasAndValueMap) {
        Validate.notNull(aliasBean, "aliasBean can't be null!", new Object[0]);
        if (Validator.isNullOrEmpty(aliasAndValueMap)) {
            return aliasBean;
        }
        Map<String, String> propertyNameAndAliasMap = BeanUtil.buildPropertyNameAndAliasMap(aliasBean.getClass());
        for (Map.Entry<String, String> entry : propertyNameAndAliasMap.entrySet()) {
            String alias = entry.getValue();
            Object value = aliasAndValueMap.get(alias);
            if (!Validator.isNotNullOrEmpty(value)) continue;
            BeanUtil.setProperty(aliasBean, entry.getKey(), value);
        }
        return aliasBean;
    }

    private static Map<String, String> buildPropertyNameAndAliasMap(Class<?> klass) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        List<Field> aliasFieldsList = FieldUtils.getFieldsListWithAnnotation(klass, Alias.class);
        if (Validator.isNullOrEmpty(aliasFieldsList)) {
            return Collections.emptyMap();
        }
        Map<String, String> propertyNameAndAliasMap = MapUtil.newHashMap(aliasFieldsList.size());
        for (Field field : aliasFieldsList) {
            Alias alias = field.getAnnotation(Alias.class);
            propertyNameAndAliasMap.put(field.getName(), alias.name());
        }
        return propertyNameAndAliasMap;
    }

    public static DynaBean newDynaBean(Map<?, ?> valueMap) {
        Validate.notNull(valueMap, "valueMap can't be null!", new Object[0]);
        LazyDynaBean lazyDynaBean = new LazyDynaBean();
        for (Map.Entry<?, ?> entry : valueMap.entrySet()) {
            String key = ConvertUtil.toString(entry.getKey());
            Validate.notBlank(key, "entry.getKey() can't be blank!", new Object[0]);
            lazyDynaBean.set(key, entry.getValue());
        }
        return lazyDynaBean;
    }

    static {
        ConvertUtil.registerStandardDefaultNull();
    }
}

