/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core;

import com.feilong.lib.lang3.ArrayUtils;
import com.feilong.lib.lang3.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class Validate {
    private Validate() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    private static <T> T notNull(T object) {
        return Validate.notNull(object, "The validated object is null", new Object[0]);
    }

    public static <T> T notNull(T object, String message, Object ... values) {
        return Objects.requireNonNull(object, () -> String.format(message, values));
    }

    public static <T> T[] notEmpty(T[] array, String message, Object ... values) {
        Objects.requireNonNull(array, () -> String.format(message, values));
        if (array.length == 0) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message, Object ... values) {
        Objects.requireNonNull(collection, () -> String.format(message, values));
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map, String message, Object ... values) {
        Objects.requireNonNull(map, () -> String.format(message, values));
        if (map.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return map;
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message, Object ... values) {
        Objects.requireNonNull(chars, () -> String.format(message, values));
        if (chars.length() == 0) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return chars;
    }

    public static <T extends CharSequence> T notBlank(T chars, String message, Object ... values) {
        Objects.requireNonNull(chars, () -> String.format(message, values));
        if (StringUtils.isBlank(chars)) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return chars;
    }

    public static <T> T[] noNullElements(T[] array, String message, Object ... values) {
        Validate.notNull(array);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            Object[] values2 = ArrayUtils.add(values, Integer.valueOf(i));
            throw new IllegalArgumentException(String.format(message, values2));
        }
        return array;
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message, Object ... values) {
        Validate.notNull(iterable);
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                Object[] values2 = ArrayUtils.addAll(values, i);
                throw new IllegalArgumentException(String.format(message, values2));
            }
            ++i;
        }
        return iterable;
    }

    public static void validState(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalStateException(String.format(message, values));
        }
    }
}

