/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker.http;

import com.feilong.context.Rebuilder;
import com.feilong.context.beanproperty.HttpTypeBeanProperty;
import com.feilong.context.invoker.RequestParamsBuilder;
import com.feilong.context.invoker.http.HttpRequestBuilder;
import com.feilong.context.invoker.http.HttpRequestUriResolver;
import com.feilong.context.invoker.http.RequestBodyBuilder;
import com.feilong.context.invoker.http.RequestHeaderBuilder;
import com.feilong.core.util.SortUtil;
import com.feilong.net.http.HttpRequest;
import java.util.Collections;
import java.util.Map;

public class DefaultHttpRequestBuilder<T>
implements HttpRequestBuilder<T> {
    private HttpTypeBeanProperty httpTypeBeanProperty;
    private RequestParamsBuilder<T> requestParamsBuilder;
    private RequestHeaderBuilder<T> requestHeaderBuilder;
    private RequestBodyBuilder<T> requestBodyBuilder;
    private Rebuilder<HttpRequest> httpRequestRebuilder;

    @Override
    public HttpRequest build(T request) {
        String uri = HttpRequestUriResolver.resolve(this.httpTypeBeanProperty.getUri(), request);
        HttpRequest httpRequest = new HttpRequest(uri, SortUtil.sortMapByKeyAsc(this.buildRequestParamsMap(request)), this.httpTypeBeanProperty.getMethod());
        httpRequest.setHeaderMap(this.buildRequestHeaderMap(request));
        httpRequest.setRequestBody(null == this.requestBodyBuilder ? null : this.requestBodyBuilder.build(request));
        if (null != this.httpRequestRebuilder) {
            return this.httpRequestRebuilder.rebuild(httpRequest);
        }
        return httpRequest;
    }

    private Map<String, String> buildRequestParamsMap(T request) {
        return null == this.requestParamsBuilder ? Collections.emptyMap() : this.requestParamsBuilder.build(request);
    }

    private Map<String, String> buildRequestHeaderMap(T request) {
        return null == this.requestHeaderBuilder ? Collections.emptyMap() : this.requestHeaderBuilder.build(request);
    }

    public void setHttpTypeBeanProperty(HttpTypeBeanProperty httpTypeBeanProperty) {
        this.httpTypeBeanProperty = httpTypeBeanProperty;
    }

    public void setRequestParamsBuilder(RequestParamsBuilder<T> requestParamsBuilder) {
        this.requestParamsBuilder = requestParamsBuilder;
    }

    public void setRequestHeaderBuilder(RequestHeaderBuilder<T> requestHeaderBuilder) {
        this.requestHeaderBuilder = requestHeaderBuilder;
    }

    public void setRequestBodyBuilder(RequestBodyBuilder<T> requestBodyBuilder) {
        this.requestBodyBuilder = requestBodyBuilder;
    }

    public void setHttpRequestRebuilder(Rebuilder<HttpRequest> rebuilder) {
        this.httpRequestRebuilder = rebuilder;
    }
}

