/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker;

import com.feilong.context.invoker.InvokerRequest;
import com.feilong.context.invoker.InvokerResponseBlankException;
import com.feilong.context.invoker.ResponseHandler;
import com.feilong.context.invoker.ResponseStringBuilder;
import com.feilong.context.invoker.ResponseStringHandler;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseHandler<R extends InvokerRequest>
implements ResponseHandler<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseHandler.class);
    protected ResponseStringBuilder<R> responseStringBuilder;
    protected ResponseStringHandler<R> responseStringHandler;

    @Override
    public void handle(R request) {
        String invokerResponseString = this.responseStringBuilder.build(request);
        if (Validator.isNullOrEmpty(invokerResponseString)) {
            throw new InvokerResponseBlankException("invokerResponse can't be null/empty!,request:[{}]", JsonUtil.format(request));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("NetpayRequest:[{}],invokerResponse:[{}]", (Object)JsonUtil.format(request), (Object)invokerResponseString);
        }
        this.responseStringHandler.handle(invokerResponseString, request);
    }

    public void setResponseStringBuilder(ResponseStringBuilder<R> responseStringBuilder) {
        this.responseStringBuilder = responseStringBuilder;
    }

    public void setResponseStringHandler(ResponseStringHandler<R> responseStringHandler) {
        this.responseStringHandler = responseStringHandler;
    }
}

