/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.encryptor;

import com.feilong.context.encryptor.Encryptor;
import com.feilong.context.encryptor.Encryptorable;
import com.feilong.core.CharsetType;
import com.feilong.json.JsonUtil;
import com.feilong.security.symmetric.SymmetricEncryption;
import com.feilong.security.symmetric.SymmetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricJsonHexEncryptor<T extends Encryptorable>
implements Encryptor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymmetricJsonHexEncryptor.class);
    private SymmetricType symmetricType = SymmetricType.DESede;
    private String key = SymmetricJsonHexEncryptor.class.getName();
    private String charsetName = CharsetType.UTF8;

    @Override
    public String encrypt(T bean) {
        String json = JsonUtil.format(bean, 0, 0);
        SymmetricEncryption symmetricEncryption = this.build();
        return symmetricEncryption.encryptHex(json, this.charsetName);
    }

    @Override
    public T decrypt(String encryptPayResultType, Class<T> klass) {
        SymmetricEncryption symmetricEncryption = this.build();
        String json = symmetricEncryption.decryptHex(encryptPayResultType, this.charsetName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("encryptPayResultType:[{}],json:[{}]", (Object)encryptPayResultType, (Object)json);
        }
        return (T)((Encryptorable)JsonUtil.toBean((Object)json, klass));
    }

    private SymmetricEncryption build() {
        return new SymmetricEncryption(this.symmetricType, this.key);
    }

    public void setSymmetricType(SymmetricType symmetricType) {
        this.symmetricType = symmetricType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

