/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.component.upload;

import com.feilong.component.upload.MultipartFileResolver;
import com.feilong.component.upload.MultipartFileUtil;
import com.feilong.core.Validate;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.io.IOWriteUtil;
import com.feilong.json.JsonUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DefaultMultipartFileResolver
implements MultipartFileResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultipartFileResolver.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String upload(MultipartFile multipartFile, String directoryName, String fileName) {
        Validate.notNull(multipartFile, "multipartFile can't be null!", new Object[0]);
        Validate.notBlank(directoryName, "directoryName can't be blank!", new Object[0]);
        Validate.notBlank(fileName, "fileName can't be blank!", new Object[0]);
        if (multipartFile.isEmpty()) {
            LOGGER.warn("multipartFile is empty,but you want to save to directoryName:[{}],fileName:[{}]", (Object)directoryName, (Object)fileName);
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(JsonUtil.format(MultipartFileUtil.getMultipartFileInfoMapForLogMap(multipartFile)));
        }
        try (InputStream inputStream = multipartFile.getInputStream();){
            String string = IOWriteUtil.write(inputStream, directoryName, fileName);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(Slf4jUtil.format("directoryName:[{}],fileName:[{}]", directoryName, fileName), e);
        }
    }

    @Override
    public List<String> upload(MultipartFile[] multipartFiles, String directoryName, String[] fileNames) {
        Validate.notEmpty(multipartFiles, "multipartFiles can't be empty!", new Object[0]);
        Validate.notEmpty(fileNames, "fileNames can't be empty!", new Object[0]);
        List<String> list = CollectionsUtil.newArrayList();
        for (int i = 0; i < multipartFiles.length; ++i) {
            MultipartFile multipartFile = multipartFiles[i];
            if (multipartFile.isEmpty()) continue;
            String fileName = fileNames[i];
            Validate.notBlank(fileName, "fileName can't be blank!", new Object[0]);
            list.add(this.upload(multipartFile, directoryName, fileName));
        }
        return list;
    }
}

