/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.accessor.session;

import com.feilong.servlet.http.SessionUtil;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionKeyAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSessionKeyAccessor.class);

    protected void commonSave(String key, Serializable serializable, HttpServletRequest request) {
        SessionUtil.setAttribute(request, key, serializable);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setAttribute to session,key is:[{}],value is:[{}]", (Object)key, (Object)AbstractSessionKeyAccessor.format(serializable));
        }
    }

    public <T extends Serializable> T get(String key, HttpServletRequest request) {
        Serializable t = (Serializable)SessionUtil.getAttribute(request, key);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("when key is :[{}],get from session t:[{}]", (Object)key, (Object)AbstractSessionKeyAccessor.format(t));
        }
        return (T)t;
    }

    public void remove(String key, HttpServletRequest request) {
        SessionUtil.removeAttribute(request, key);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("remove session attribute,key:[{}]", (Object)key);
        }
    }

    private static String format(Serializable serializable) {
        if (null == serializable) {
            return null;
        }
        return serializable.toString();
    }
}

