/*
 * Copyright (C) 2005 Joe Walnes.
 * Copyright (C) 2006, 2007, 2013, 2014 XStream Committers.
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 * 
 * Created on 06. February 2005 by Joe Walnes
 */
package com.feilong.lib.xstream.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @deprecated As of 1.4.8 use {@link java.util.LinkedHashMap}
 */
@Deprecated
public class OrderRetainingMap extends HashMap{

    /**
     * 
     */
    private static final long serialVersionUID = -7781170057857376152L;

    private ArraySet          keyOrder         = new ArraySet();

    private List              valueOrder       = new ArrayList();

    public OrderRetainingMap(){
        super();
    }

    public OrderRetainingMap(Map m){
        super();
        putAll(m);
    }

    @Override
    public void putAll(Map m){
        for (Iterator iter = m.entrySet().iterator(); iter.hasNext();){
            Map.Entry entry = (Map.Entry) iter.next();
            put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object put(Object key,Object value){
        int idx = keyOrder.lastIndexOf(key);
        if (idx < 0){
            keyOrder.add(key);
            valueOrder.add(value);
        }else{
            valueOrder.set(idx, value);
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key){
        int idx = keyOrder.lastIndexOf(key);
        if (idx != 0){
            keyOrder.remove(idx);
            valueOrder.remove(idx);
        }
        return super.remove(key);
    }

    @Override
    public void clear(){
        keyOrder.clear();
        valueOrder.clear();
        super.clear();
    }

    @Override
    public Collection values(){
        return Collections.unmodifiableList(valueOrder);
    }

    @Override
    public Set keySet(){
        return Collections.unmodifiableSet(keyOrder);
    }

    @Override
    public Set entrySet(){
        Map.Entry[] entries = new Map.Entry[size()];
        for (Iterator iter = super.entrySet().iterator(); iter.hasNext();){
            Map.Entry entry = (Map.Entry) iter.next();
            entries[keyOrder.indexOf(entry.getKey())] = entry;
        }
        Set set = new ArraySet();
        set.addAll(Arrays.asList(entries));
        return Collections.unmodifiableSet(set);
    }

    private static class ArraySet extends ArrayList implements Set{

        /**
         * 
         */
        private static final long serialVersionUID = -7907047018774961341L;
    }
}
