/*
 * Copyright (C) 2006, 2007, 2008, 2009 XStream Committers.
 * All rights reserved.
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 * 
 * Created on 26.09.2007 by Joerg Schaible
 */
package com.feilong.lib.xstream.core;

import com.feilong.lib.xstream.MarshallingStrategy;
import com.feilong.lib.xstream.converters.ConverterLookup;
import com.feilong.lib.xstream.converters.DataHolder;
import com.feilong.lib.xstream.io.HierarchicalStreamReader;
import com.feilong.lib.xstream.io.HierarchicalStreamWriter;
import com.feilong.lib.xstream.mapper.Mapper;

/**
 * Basic functionality of a tree based marshalling strategy.
 * 
 * @author Joe Walnes
 * @author J&ouml;rg Schaible
 * @since 1.3
 */
public abstract class AbstractTreeMarshallingStrategy implements MarshallingStrategy{

    @Override
    public Object unmarshal(
                    Object root,
                    HierarchicalStreamReader reader,
                    DataHolder dataHolder,
                    ConverterLookup converterLookup,
                    Mapper mapper){
        TreeUnmarshaller context = createUnmarshallingContext(root, reader, converterLookup, mapper);
        return context.start(dataHolder);
    }

    @Override
    public void marshal(HierarchicalStreamWriter writer,Object obj,ConverterLookup converterLookup,Mapper mapper,DataHolder dataHolder){
        TreeMarshaller context = createMarshallingContext(writer, converterLookup, mapper);
        context.start(obj, dataHolder);
    }

    protected abstract TreeUnmarshaller createUnmarshallingContext(
                    Object root,
                    HierarchicalStreamReader reader,
                    ConverterLookup converterLookup,
                    Mapper mapper);

    protected abstract TreeMarshaller createMarshallingContext(
                    HierarchicalStreamWriter writer,
                    ConverterLookup converterLookup,
                    Mapper mapper);
}
