/*
 * Copyright (C) 2008 feilong
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.feilong.context.invoker;

/**
 * 处理响应字符串和请求对象.
 * 
 * <p>
 * 类型于一个回调函数
 * </p>
 *
 * @author <a href="https://github.com/ifeilong/feilong">feilong</a>
 * @param <R>
 *            请求
 * @since 2.1.0
 */
public interface ResponseStringHandler<R extends InvokerRequest> {

    /**
     * 处理响应字符串和 请求request.
     *
     * @param responseString
     *            the response string
     * @param request
     *            the request
     */
    void handle(String responseString,R request);

}
