/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import com.icebuf.util.PackageUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    public static final String TAG = FileUtil.class.getSimpleName();
    public static String SYSTEM_PROVIDER = "com.android.settings.files";
    public static String USER_PROVIDER = null;
    public static final String MIME_APK = "application/vnd.android.package-archive";
    public static final int REQUEST_CODE_INSTALL_APK = 1001;
    public static final String DIR_RULE = "\\/:*?\"<>|";
    private static final String[] UPPER_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    public static final int NO_ERROR = 0;
    public static final int ERROR_CODE_SRC_EXISTS = -1;
    public static final int ERROR_CODE_DST_EXISTS = -2;
    public static final int ERROR_CODE_SRC_NOT_EXISTS = -3;
    public static final int ERROR_CODE_DST_NOT_EXISTS = -4;
    public static final int ERROR_CODE_MKDIR = -5;
    public static final int ERROR_CODE_CREATE = -6;
    public static final int ERROR_CODE_DELETE = -7;
    public static final int ERROR_CODE_READ = -8;
    public static final int ERROR_CODE_WRITE = -9;
    public static final int ERROR_CODE_IO = -10;
    public static final int ERROR_CODE_RENAME = -11;
    public static final int ERROR_CODE_FILE_NAME_EMPTY = -12;
    public static final int ERROR_CODE_FILE_NAME_START = -13;
    public static final int ERROR_CODE_FILE_NAME_RULE = -14;

    public static void openFile(Context context, File file) throws Exception {
        PackageManager pm;
        List resInfoList;
        Uri contentUri;
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            intent.addFlags(2);
            intent.addFlags(64);
            int uid = PackageUtil.getAppUid(context);
            String userProvider = TextUtils.isEmpty((CharSequence)USER_PROVIDER) ? context.getPackageName() + ".fileprovider" : USER_PROVIDER;
            String authority = uid == 1000 ? SYSTEM_PROVIDER : userProvider;
            Log.i((String)TAG, (String)("package uid\uff1a" + uid + " authority: " + authority));
            contentUri = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        } else {
            contentUri = Uri.fromFile((File)file);
        }
        String type = FileUtil.getMimeType("file://" + file.getPath());
        if (type == null) {
            throw new NullPointerException("mime type is null!");
        }
        intent.setDataAndType(contentUri, type);
        if (type.equals(MIME_APK) && !FileUtil.checkInstallPermission(context)) {
            Log.e((String)TAG, (String)("open file " + file.getPath() + " need install permission"));
        }
        if ((resInfoList = (pm = context.getPackageManager()).queryIntentActivities(intent, 0)).size() <= 0) {
            throw new ActivityNotFoundException("not found any activity can resolve the intent of file : " + file.getPath());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                context.grantUriPermission(packageName, contentUri, 67);
            }
        }
        context.startActivity(intent);
    }

    private static boolean checkInstallPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.REQUEST_INSTALL_PACKAGES") == -1) {
            if (context instanceof Activity) {
                ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.REQUEST_INSTALL_PACKAGES"}, (int)1001);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                PackageManager pm = context.getPackageManager();
                return pm.canRequestPackageInstalls();
            }
            return false;
        }
        return true;
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = FileUtil.getExtension(url);
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.toLowerCase());
        }
        Log.i((String)TAG, (String)("MIME type\uff1a" + (type == null ? "null" : type)));
        return type;
    }

    public static String getExtension(String url) {
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (TextUtils.isEmpty((CharSequence)extension)) {
            int start = url.lastIndexOf(".");
            if (start < 0) {
                return "";
            }
            extension = url.substring(start + 1);
        }
        return extension;
    }

    public static String getFileExtension(String path) {
        return FileUtil.getExtension("file://" + path);
    }

    public static String getNameWithExtension(String name, String extension) {
        if (extension.toLowerCase().startsWith(".")) {
            extension = "." + extension;
        }
        return name.toLowerCase().lastIndexOf(extension) > 0 ? name : name + extension;
    }

    public static String readableFileSize(long size) {
        return FileUtil.readableFileSize(size, 1);
    }

    public static String readableFileSize(long size, int decimalCount) {
        if (size <= 0L) {
            return UPPER_UNITS[0];
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        StringBuilder pattern = new StringBuilder("#,##0");
        if (decimalCount > 0) {
            pattern.append(".");
            for (int i = 0; i < Math.min(3, decimalCount); ++i) {
                pattern.append("#");
            }
        }
        return new DecimalFormat(pattern.toString()).format((double)size / Math.pow(1024.0, digitGroups)) + " " + UPPER_UNITS[digitGroups];
    }

    public static String nextDateFileName(String path, String datePattern) {
        SimpleDateFormat df = new SimpleDateFormat(datePattern, Locale.getDefault());
        String date = df.format(new Date());
        return FileUtil.nextFileName(path, date);
    }

    public static String nextFileName(String path, final String dstName) {
        File file = new File(path);
        String[] files = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(dstName);
            }
        });
        if (files == null || files.length == 0) {
            return dstName;
        }
        int i = 1;
        boolean contains = true;
        String newName = dstName;
        block0: while (contains) {
            contains = false;
            for (String str : files) {
                if (!str.equals(dstName)) continue;
                newName = dstName + "_" + i++;
                contains = true;
                continue block0;
            }
        }
        return newName;
    }

    public static File verifyFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        if (file.mkdirs()) {
            return file;
        }
        return null;
    }

    public static void copyFileWithChannel(File source, File dest) throws IOException {
        try (FileChannel sourceChannel = new FileInputStream(source).getChannel();
             FileChannel destChannel = new FileOutputStream(dest).getChannel();){
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
    }

    public static String getErrorTag(Context context, File file, int errorFlag) {
        String fileName = file == null ? "" : file.getName();
        return FileUtil.getErrorTag(context, fileName, errorFlag);
    }

    public static String getErrorTag(Context context, String fileName, int errorFlag) {
        String tag = "";
        return tag;
    }

    public static int mkdir(@NonNull String path, @NonNull String name) {
        return FileUtil.mkdir(new File(path, name));
    }

    public static int mkdir(File file) {
        if (file.exists()) {
            return -1;
        }
        boolean result = file.mkdir();
        if (!result) {
            return -5;
        }
        return 0;
    }

    public static int copyFileTo(@NonNull File source, @NonNull String destPath) {
        if (!source.exists()) {
            return -3;
        }
        if (!source.canRead()) {
            return -8;
        }
        File dest = new File(destPath);
        if (!dest.exists()) {
            return -4;
        }
        if (!dest.canWrite()) {
            return -9;
        }
        String destName = FileUtil.obtainFileName(destPath, source.getName());
        try {
            FileUtil.copyFileUsingStream(source, new File(dest, destName));
        }
        catch (IOException e) {
            e.printStackTrace();
            return -10;
        }
        return 0;
    }

    private static String obtainFileName(String destPath, String srcName) {
        File file = new File(destPath, srcName);
        if (!file.exists()) {
            return srcName;
        }
        String extension = "." + FileUtil.getFileExtension(file.getPath());
        srcName = srcName.replace(extension, "");
        String regex = srcName + "\u7684\u526f\u672c(( \\d+)*)" + extension + "$";
        Pattern pattern = Pattern.compile(regex);
        String newName = srcName + "\u7684\u526f\u672c";
        File parent = file.getParentFile();
        if (parent == null) {
            return srcName;
        }
        String[] names = parent.list();
        if (names == null) {
            return srcName;
        }
        TreeSet<Integer> indexList = new TreeSet<Integer>();
        for (String name : names) {
            Matcher matcher = pattern.matcher(name);
            while (matcher.find()) {
                Log.d((String)TAG, (String)("name: " + name + " \u5339\u914d\u6210\u529f\uff01"));
                int i = matcher.groupCount();
                String str = matcher.group(i - 1);
                if (TextUtils.isEmpty((CharSequence)str)) {
                    indexList.add(1);
                    continue;
                }
                str = str.replace(" ", "");
                int value = Integer.parseInt(str);
                indexList.add(value);
            }
        }
        int index = 1;
        while (indexList.contains(index)) {
            ++index;
        }
        if (index == 1) {
            return newName + extension;
        }
        return newName + " " + index + extension;
    }

    public static int checkFileName(@NonNull String name) {
        if (name.equals("")) {
            return -12;
        }
        if (name.startsWith(".") || name.startsWith("..")) {
            return -13;
        }
        for (int i = 0; i < DIR_RULE.length(); ++i) {
            String ch = DIR_RULE.charAt(i) + "";
            if (!name.contains(ch)) continue;
            return -14;
        }
        return 0;
    }

    public static int renameTo(File file, String destPath) {
        boolean success;
        File dir = new File(destPath);
        if (!dir.exists()) {
            return -2;
        }
        if (!dir.canWrite()) {
            return -9;
        }
        String[] names = dir.list();
        if (names != null) {
            for (String name : names) {
                if (!name.equals(file.getName())) continue;
                return -2;
            }
        }
        return (success = file.renameTo(new File(dir, file.getName()))) ? 0 : -11;
    }

    public static int copyDirTo(File file, String destPath) {
        return FileUtil.copyDirTo(file, destPath, null);
    }

    public static int copyDirTo(File file, String destPath, CopyListener listener) {
        if (file.isDirectory()) {
            File dir = new File(destPath, file.getName());
            int result = FileUtil.mkdir(dir);
            if (result < 0) {
                return result;
            }
            Log.e((String)TAG, (String)("\u521b\u5efa\u6587\u4ef6\u5939\uff1a" + dir.getPath() + " \u6210\u529f\uff01"));
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    result = FileUtil.copyDirTo(child, dir.getPath(), listener);
                    if (result >= 0) continue;
                    return result;
                }
            }
            Log.e((String)TAG, (String)("\u6587\u4ef6\u5939\uff1a" + file.getPath() + " \u590d\u5236\u6210\u529f\uff01"));
            if (listener != null) {
                listener.onCopyFile(file);
            }
        } else {
            int result = FileUtil.copyFileTo(file, destPath);
            if (result < 0) {
                return result;
            }
            Log.e((String)TAG, (String)("\u590d\u5236\u6587\u4ef6\uff1a" + file.getPath() + " \u6210\u529f\uff01"));
            if (listener != null) {
                listener.onCopyFile(file);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[2048];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static int deleteFiles(List<String> paths) {
        if (paths == null) {
            return 0;
        }
        for (String path : paths) {
            File file = new File(path);
            int ret = FileUtil.deleteFile(file);
            if (ret >= 0) continue;
            return ret;
        }
        return 0;
    }

    public static int deleteFiles(String ... paths) {
        if (paths == null || paths.length <= 0) {
            return 0;
        }
        for (String path : paths) {
            File file = new File(path);
            int ret = FileUtil.deleteFile(file);
            if (ret >= 0) continue;
            return ret;
        }
        return 0;
    }

    public static int deleteFile(@NonNull File file) {
        if (!file.exists()) {
            return 0;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                int ret = FileUtil.deleteFile(child);
                if (ret >= 0) continue;
                return ret;
            }
        }
        if (file.delete()) {
            return 0;
        }
        return -7;
    }

    public static int getFileCount(@NonNull File file) {
        File[] files;
        int count = 1;
        for (File child : files = file.listFiles()) {
            ++count;
            if (!child.isDirectory()) continue;
            count += FileUtil.getFileCount(child);
        }
        return count;
    }

    public static void searchFile(@NonNull File file, @NonNull List<File> resultList, @NonNull FileFilter fileFilter, @Nullable SearchListener listener) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (fileFilter.accept(file)) {
                resultList.add(file);
                if (listener != null) {
                    listener.onSearched(file);
                }
                Log.e((String)TAG, (String)("\u627e\u5230\u6587\u4ef6\uff1a" + file.getName()));
            }
            return;
        }
        if (!file.canRead()) {
            return;
        }
        if (listener != null && listener.isCancel()) {
            return;
        }
        for (File child : files = file.listFiles()) {
            FileUtil.searchFile(child, resultList, fileFilter, listener);
        }
    }

    public static void searchFile2(@NonNull File file, @NonNull List<File> resultList, @NonNull FileFilter fileFilter, @Nullable SearchListener listener) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (fileFilter.accept(file) && listener != null) {
                listener.onSearched(file);
            }
            return;
        }
        if (!file.canRead()) {
            return;
        }
        ArrayList<File> currentLevelNodes = new ArrayList<File>();
        currentLevelNodes.add(file);
        while (currentLevelNodes.size() > 0) {
            ArrayList<File> nextLevelNodes = new ArrayList<File>();
            for (File f : currentLevelNodes) {
                if (fileFilter.accept(f)) {
                    resultList.add(f);
                    if (listener != null) {
                        listener.onSearched(f);
                    }
                }
                if (FileUtil.hasChildren(f)) {
                    nextLevelNodes.addAll(Arrays.asList(f.listFiles()));
                }
                if (listener == null || !listener.isCancel()) continue;
                break;
            }
            currentLevelNodes = nextLevelNodes;
            if (listener == null || !listener.isCancel()) continue;
            break;
        }
    }

    private static boolean hasChildren(File f) {
        boolean flag = false;
        File[] list = null;
        if (f.isDirectory()) {
            list = f.listFiles();
        }
        if (null != list && list.length > 0) {
            flag = true;
        }
        return flag;
    }

    public static interface SearchListener {
        public void onSearched(File var1);

        public boolean isCancel();
    }

    public static interface CopyListener {
        public void onCopyFile(File var1);
    }
}

