/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.library;

import android.arch.lifecycle.MutableLiveData;
import android.content.SharedPreferences;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B1\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ibrahimsn/library/MultiPreference;", "T", "Landroid/arch/lifecycle/MutableLiveData;", "Lkotlin/Pair;", "", "updates", "Lio/reactivex/Observable;", "preferences", "Landroid/content/SharedPreferences;", "keys", "", "defaultValue", "(Lio/reactivex/Observable;Landroid/content/SharedPreferences;Ljava/util/List;Ljava/lang/Object;)V", "Ljava/lang/Object;", "disposable", "Lio/reactivex/disposables/CompositeDisposable;", "library_release"})
public final class MultiPreference<T>
extends MutableLiveData<Pair<? extends String, ? extends T>> {
    private final CompositeDisposable disposable;
    private final SharedPreferences preferences;
    private final List<String> keys;
    private final T defaultValue;

    public MultiPreference(@NotNull Observable<String> updates, @NotNull SharedPreferences preferences, @NotNull List<String> keys, T defaultValue) {
        Intrinsics.checkParameterIsNotNull(updates, (String)"updates");
        Intrinsics.checkParameterIsNotNull((Object)preferences, (String)"preferences");
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        this.preferences = preferences;
        this.keys = keys;
        this.defaultValue = defaultValue;
        this.disposable = new CompositeDisposable();
        this.disposable.add((Disposable)updates.filter((Predicate)new Predicate<String>(){

            public final boolean test(@NotNull String t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                return keys.contains(t);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribeWith((Observer)new DisposableObserver<String>(){

            public void onComplete() {
            }

            public void onNext(@NotNull String t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Object object = preferences.getAll().get(t);
                if (object == null) {
                    object = defaultValue;
                }
                this.postValue(new Pair((Object)t, object));
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }
        }));
    }
}

