/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.lib;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.FontRes;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ibrahimsn.lib.BottomBarItem;
import me.ibrahimsn.lib.BottomBarParser;
import me.ibrahimsn.lib.OnItemReselectedListener;
import me.ibrahimsn.lib.OnItemSelectedListener;
import me.ibrahimsn.lib.R;
import me.ibrahimsn.lib.RoundRectDrawable;
import me.ibrahimsn.lib.SmoothBottomBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020\tH\u0002J\b\u00108\u001a\u00020$H\u0002J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\tH\u0002J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0002J\u0006\u0010=\u001a\u00020\tJ\u0010\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020@H\u0014J(\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020\tH\u0014J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0017J\u000e\u0010J\u001a\u00020$2\u0006\u0010:\u001a\u00020\tJ\u000e\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020*J\u000e\u0010M\u001a\u00020$2\u0006\u0010L\u001a\u00020/R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020$0#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020$0#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010&\"\u0004\b-\u0010(R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lme/ibrahimsn/lib/SmoothBottomBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "activeItemIndex", "barBackgroundColor", "barCornerRadius", "", "barIndicatorColor", "barIndicatorRadius", "barSideMargins", "currentIconTint", "indicatorLocation", "itemAnimDuration", "", "itemFontFamily", "itemIconMargin", "itemIconSize", "itemIconTint", "itemIconTintActive", "itemPadding", "itemTextColor", "itemTextSize", "itemWidth", "items", "", "Lme/ibrahimsn/lib/BottomBarItem;", "onItemReselected", "Lkotlin/Function1;", "", "getOnItemReselected", "()Lkotlin/jvm/functions/Function1;", "setOnItemReselected", "(Lkotlin/jvm/functions/Function1;)V", "onItemReselectedListener", "Lme/ibrahimsn/lib/OnItemReselectedListener;", "onItemSelected", "getOnItemSelected", "setOnItemSelected", "onItemSelectedListener", "Lme/ibrahimsn/lib/OnItemSelectedListener;", "paintIndicator", "Landroid/graphics/Paint;", "paintText", "rect", "Landroid/graphics/RectF;", "animateAlpha", "item", "to", "animateIconTint", "animateIndicator", "pos", "d2p", "dp", "getActiveItem", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "setActiveItem", "setOnItemReselectedListener", "listener", "setOnItemSelectedListener", "lib_release"})
public final class SmoothBottomBar
extends View {
    private int barBackgroundColor;
    private int barIndicatorColor;
    private float barIndicatorRadius;
    private float barSideMargins;
    private float barCornerRadius;
    private float itemPadding;
    private long itemAnimDuration;
    private float itemIconSize;
    private float itemIconMargin;
    private int itemIconTint;
    private int itemIconTintActive;
    private int itemTextColor;
    private float itemTextSize;
    @FontRes
    private int itemFontFamily;
    private float itemWidth;
    private int activeItemIndex;
    private int currentIconTint;
    private float indicatorLocation;
    private List<BottomBarItem> items;
    private OnItemSelectedListener onItemSelectedListener;
    private OnItemReselectedListener onItemReselectedListener;
    @NotNull
    private Function1<? super Integer, Unit> onItemSelected;
    @NotNull
    private Function1<? super Integer, Unit> onItemReselected;
    private final RectF rect;
    private final Paint paintIndicator;
    private final Paint paintText;
    private HashMap _$_findViewCache;

    @NotNull
    public final Function1<Integer, Unit> getOnItemSelected() {
        return this.onItemSelected;
    }

    public final void setOnItemSelected(@NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onItemSelected = function1;
    }

    @NotNull
    public final Function1<Integer, Unit> getOnItemReselected() {
        return this.onItemReselected;
    }

    public final void setOnItemReselected(@NotNull Function1<? super Integer, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onItemReselected = function1;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float lastX = this.barSideMargins;
        this.itemWidth = ((float)this.getWidth() - this.barSideMargins * (float)2) / (float)this.items.size();
        for (BottomBarItem item : this.items) {
            boolean shorted = false;
            while (this.paintText.measureText(item.getTitle()) > this.itemWidth - this.itemIconSize - this.itemIconMargin - this.itemPadding * (float)2) {
                item.setTitle(StringsKt.dropLast((String)item.getTitle(), (int)1));
                shorted = true;
            }
            if (shorted) {
                item.setTitle(StringsKt.dropLast((String)item.getTitle(), (int)1));
                BottomBarItem bottomBarItem = item;
                bottomBarItem.setTitle(bottomBarItem.getTitle() + this.getContext().getString(R.string.ellipsis));
            }
            item.setRect(new RectF(lastX, 0.0f, this.itemWidth + lastX, (float)this.getHeight()));
            lastX += this.itemWidth;
        }
        this.setActiveItem(this.activeItemIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.rect.left = this.indicatorLocation;
        this.rect.top = this.items.get(this.activeItemIndex).getRect().centerY() - this.itemIconSize / (float)2 - this.itemPadding;
        this.rect.right = this.indicatorLocation + this.itemWidth;
        this.rect.bottom = this.items.get(this.activeItemIndex).getRect().centerY() + this.itemIconSize / (float)2 + this.itemPadding;
        canvas.drawRoundRect(this.rect, this.barIndicatorRadius, this.barIndicatorRadius, this.paintIndicator);
        float textHeight = (this.paintText.descent() + this.paintText.ascent()) / (float)2;
        boolean bl = false;
        for (BottomBarItem item : (Iterable)this.items) {
            void index;
            float textLength = this.paintText.measureText(item.getTitle());
            item.getIcon().mutate();
            item.getIcon().setBounds((int)item.getRect().centerX() - (int)this.itemIconSize / 2 - (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 - (int)this.itemIconSize / 2, (int)item.getRect().centerX() + (int)this.itemIconSize / 2 - (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 + (int)this.itemIconSize / 2);
            DrawableCompat.setTint((Drawable)item.getIcon(), (int)(index == this.activeItemIndex ? this.currentIconTint : this.itemIconTint));
            item.getIcon().draw(canvas);
            this.paintText.setAlpha(item.getAlpha());
            canvas.drawText(item.getTitle(), item.getRect().centerX() + this.itemIconSize / (float)2 + this.itemIconMargin, item.getRect().centerY() - textHeight, this.paintText);
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getAction() == 1) {
            long l = event.getDownTime() - event.getEventTime();
            boolean bl = false;
            if (Math.abs(l) < (long)500) {
                boolean bl2 = false;
                for (BottomBarItem item : (Iterable)this.items) {
                    void itemId;
                    if (item.getRect().contains(event.getX(), event.getY())) {
                        if (itemId != this.activeItemIndex) {
                            this.setActiveItem((int)itemId);
                            this.onItemSelected.invoke((Object)((int)itemId));
                            OnItemSelectedListener onItemSelectedListener = this.onItemSelectedListener;
                            if (onItemSelectedListener != null) {
                                onItemSelectedListener.onItemSelect((int)itemId);
                            }
                        } else {
                            this.onItemReselected.invoke((Object)((int)itemId));
                            OnItemReselectedListener onItemReselectedListener = this.onItemReselectedListener;
                            if (onItemReselectedListener != null) {
                                onItemReselectedListener.onItemReselect((int)itemId);
                            }
                        }
                    }
                    ++itemId;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveItem(int pos) {
        this.activeItemIndex = pos;
        boolean bl = false;
        for (BottomBarItem item : (Iterable)this.items) {
            void index;
            if (index == pos) {
                this.animateAlpha(item, 255);
            } else {
                this.animateAlpha(item, 0);
            }
            ++index;
        }
        this.animateIndicator(pos);
        this.animateIconTint();
    }

    public final int getActiveItem() {
        return this.activeItemIndex;
    }

    private final void animateAlpha(BottomBarItem item, int to) {
        ValueAnimator animator;
        ValueAnimator valueAnimator = animator = ValueAnimator.ofInt((int[])new int[]{item.getAlpha(), to});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration(this.itemAnimDuration);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, item){
            final /* synthetic */ SmoothBottomBar this$0;
            final /* synthetic */ BottomBarItem $item;

            public final void onAnimationUpdate(ValueAnimator it) {
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                int value = (Integer)object;
                this.$item.setAlpha(value);
                this.this$0.invalidate();
            }
            {
                this.this$0 = smoothBottomBar;
                this.$item = bottomBarItem;
            }
        });
        animator.start();
    }

    private final void animateIndicator(int pos) {
        ValueAnimator animator;
        ValueAnimator valueAnimator = animator = ValueAnimator.ofFloat((float[])new float[]{this.indicatorLocation, this.items.get((int)pos).getRect().left});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration(this.itemAnimDuration);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothBottomBar this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                SmoothBottomBar.access$setIndicatorLocation$p(this.this$0, ((Float)object).floatValue());
            }
            {
                this.this$0 = smoothBottomBar;
            }
        });
        animator.start();
    }

    private final void animateIconTint() {
        ValueAnimator animator;
        ValueAnimator valueAnimator = animator = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])new Object[]{this.itemIconTint, this.itemIconTintActive});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration(this.itemAnimDuration);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothBottomBar this$0;

            public final void onAnimationUpdate(ValueAnimator it) {
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                SmoothBottomBar.access$setCurrentIconTint$p(this.this$0, (Integer)object);
            }
            {
                this.this$0 = smoothBottomBar;
            }
        });
        animator.start();
    }

    private final float d2p(float dp) {
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (float)resources.getDisplayMetrics().densityDpi / (float)160 * dp;
    }

    public final void setOnItemSelectedListener(@NotNull OnItemSelectedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onItemSelectedListener = listener;
    }

    public final void setOnItemReselectedListener(@NotNull OnItemReselectedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onItemReselectedListener = listener;
    }

    public SmoothBottomBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public SmoothBottomBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public SmoothBottomBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.barBackgroundColor = Color.parseColor((String)"#FFFFFF");
        this.barIndicatorColor = Color.parseColor((String)"#2DFFFFFF");
        this.barIndicatorRadius = this.d2p(20.0f);
        this.barSideMargins = this.d2p(10.0f);
        this.barCornerRadius = this.d2p(0.0f);
        this.itemPadding = this.d2p(10.0f);
        this.itemAnimDuration = 200L;
        this.itemIconSize = this.d2p(18.0f);
        this.itemIconMargin = this.d2p(4.0f);
        this.itemIconTint = Color.parseColor((String)"#C8FFFFFF");
        this.itemIconTintActive = Color.parseColor((String)"#FFFFFF");
        this.itemTextColor = Color.parseColor((String)"#FFFFFF");
        this.itemTextSize = this.d2p(11.0f);
        this.currentIconTint = this.itemIconTintActive;
        this.indicatorLocation = this.barSideMargins;
        SmoothBottomBar smoothBottomBar = this;
        boolean bl = false;
        smoothBottomBar.items = list = CollectionsKt.emptyList();
        this.onItemSelected = onItemSelected.1.INSTANCE;
        this.onItemReselected = onItemReselected.1.INSTANCE;
        this.rect = new RectF();
        Paint paint = new Paint();
        smoothBottomBar = this;
        boolean bl2 = false;
        boolean bl3 = false;
        Paint $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.barIndicatorColor);
        list = paint;
        smoothBottomBar.paintIndicator = list;
        paint = new Paint();
        smoothBottomBar = this;
        bl2 = false;
        bl3 = false;
        $this$apply = paint;
        boolean bl5 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.itemTextColor);
        $this$apply.setTextSize(this.itemTextSize);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        $this$apply.setFakeBoldText(true);
        list = paint;
        smoothBottomBar.paintText = list;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SmoothBottomBar, 0, 0);
        this.barBackgroundColor = typedArray.getColor(R.styleable.SmoothBottomBar_backgroundColor, this.barBackgroundColor);
        this.barIndicatorColor = typedArray.getColor(R.styleable.SmoothBottomBar_indicatorColor, this.barIndicatorColor);
        this.barIndicatorRadius = typedArray.getDimension(R.styleable.SmoothBottomBar_indicatorRadius, this.barIndicatorRadius);
        this.barSideMargins = typedArray.getDimension(R.styleable.SmoothBottomBar_sideMargins, this.barSideMargins);
        this.barCornerRadius = typedArray.getDimension(R.styleable.SmoothBottomBar_cornerRadius, this.barCornerRadius);
        this.itemPadding = typedArray.getDimension(R.styleable.SmoothBottomBar_itemPadding, this.itemPadding);
        this.itemTextColor = typedArray.getColor(R.styleable.SmoothBottomBar_textColor, this.itemTextColor);
        this.itemTextSize = typedArray.getDimension(R.styleable.SmoothBottomBar_textSize, this.itemTextSize);
        this.itemIconSize = typedArray.getDimension(R.styleable.SmoothBottomBar_iconSize, this.itemIconSize);
        this.itemIconTint = typedArray.getColor(R.styleable.SmoothBottomBar_iconTint, this.itemIconTint);
        this.itemIconTintActive = typedArray.getColor(R.styleable.SmoothBottomBar_iconTintActive, this.itemIconTintActive);
        this.activeItemIndex = typedArray.getInt(R.styleable.SmoothBottomBar_activeItem, this.activeItemIndex);
        this.itemFontFamily = typedArray.getResourceId(R.styleable.SmoothBottomBar_itemFontFamily, this.itemFontFamily);
        this.itemAnimDuration = typedArray.getInt(R.styleable.SmoothBottomBar_duration, (int)this.itemAnimDuration);
        this.items = new BottomBarParser(context, typedArray.getResourceId(R.styleable.SmoothBottomBar_menu, 0)).parse();
        typedArray.recycle();
        if (Build.VERSION.SDK_INT >= 21) {
            this.setBackground(new RoundRectDrawable(ColorStateList.valueOf((int)this.barBackgroundColor), this.barCornerRadius, true, true, false, false, 48, null));
        } else {
            this.setBackgroundColor(this.barBackgroundColor);
        }
        this.paintIndicator.setColor(this.barIndicatorColor);
        this.paintText.setColor(this.itemTextColor);
        this.paintText.setTextSize(this.itemTextSize);
        if (this.itemFontFamily != 0) {
            this.paintText.setTypeface(ResourcesCompat.getFont((Context)context, (int)this.itemFontFamily));
        }
    }

    public static final /* synthetic */ float access$getIndicatorLocation$p(SmoothBottomBar $this) {
        return $this.indicatorLocation;
    }

    public static final /* synthetic */ void access$setIndicatorLocation$p(SmoothBottomBar $this, float f) {
        $this.indicatorLocation = f;
    }

    public static final /* synthetic */ int access$getCurrentIconTint$p(SmoothBottomBar $this) {
        return $this.currentIconTint;
    }

    public static final /* synthetic */ void access$setCurrentIconTint$p(SmoothBottomBar $this, int n) {
        $this.currentIconTint = n;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

