/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.lib;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ibrahimsn.lib.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ \u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0007H\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0007H\u0002J\u001e\u0010,\u001a\u0004\u0018\u00010\u001c2\b\u0010-\u001a\u0004\u0018\u00010\u00032\b\u0010.\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002002\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0007H\u0016J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0015H\u0014J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u0002002\u0006\u0010?\u001a\u000204H\u0016J\u0012\u0010@\u001a\u0002002\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020CH\u0016J\u001e\u0010D\u001a\u0002002\u0006\u0010 \u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u0007J\u0010\u0010G\u001a\u0002002\u0006\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010H\u001a\u0002002\u0006\u0010.\u001a\u00020\u001eH\u0016J\u0012\u0010I\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lme/ibrahimsn/lib/RoundRectDrawable;", "Landroid/graphics/drawable/Drawable;", "backgroundColor", "Landroid/content/res/ColorStateList;", "mRadius", "", "topLeft", "", "topRight", "bottomLeft", "bottomRight", "(Landroid/content/res/ColorStateList;FZZZZ)V", "color", "getColor", "()Landroid/content/res/ColorStateList;", "setColor", "(Landroid/content/res/ColorStateList;)V", "mBackground", "mBoundsF", "Landroid/graphics/RectF;", "mBoundsI", "Landroid/graphics/Rect;", "mInsetForPadding", "mInsetForRadius", "mPaint", "Landroid/graphics/Paint;", "mTint", "mTintFilter", "Landroid/graphics/PorterDuffColorFilter;", "mTintMode", "Landroid/graphics/PorterDuff$Mode;", "<set-?>", "padding", "getPadding", "()F", "radius", "getRadius", "setRadius", "(F)V", "calculateHorizontalPadding", "maxShadowSize", "cornerRadius", "addPaddingForCorners", "calculateVerticalPadding", "createTintFilter", "tint", "tintMode", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "", "getOutline", "outline", "Landroid/graphics/Outline;", "isStateful", "onBoundsChange", "bounds", "onStateChange", "stateSet", "", "setAlpha", "alpha", "setBackground", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "setPadding", "insetForPadding", "insetForRadius", "setTintList", "setTintMode", "updateBounds", "lib_release"})
@RequiresApi(value=21)
public final class RoundRectDrawable
extends Drawable {
    private final Paint mPaint;
    private final RectF mBoundsF;
    private final Rect mBoundsI;
    private float padding;
    private boolean mInsetForPadding;
    private boolean mInsetForRadius;
    private ColorStateList mBackground;
    private PorterDuffColorFilter mTintFilter;
    private ColorStateList mTint;
    private PorterDuff.Mode mTintMode;
    private float mRadius;
    private final boolean topLeft;
    private final boolean topRight;
    private final boolean bottomLeft;
    private final boolean bottomRight;

    public final float getPadding() {
        return this.padding;
    }

    private final void setBackground(ColorStateList color) {
        int n;
        ColorStateList colorStateList = color;
        if (colorStateList == null) {
            colorStateList = ColorStateList.valueOf((int)0);
        }
        ColorStateList colorStateList2 = this.mBackground = colorStateList;
        if (colorStateList2 != null) {
            ColorStateList colorStateList3 = this.mBackground;
            n = colorStateList2.getColorForState(this.getState(), colorStateList3 != null ? colorStateList3.getDefaultColor() : 0);
        } else {
            n = 0;
        }
        this.mPaint.setColor(n);
    }

    public final void setPadding(float padding, boolean insetForPadding, boolean insetForRadius) {
        if (padding == this.padding && this.mInsetForPadding == insetForPadding && this.mInsetForRadius == insetForRadius) {
            return;
        }
        this.padding = padding;
        this.mInsetForPadding = insetForPadding;
        this.mInsetForRadius = insetForRadius;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Paint paint = this.mPaint;
        boolean clearColorFilter = false;
        if (this.mTintFilter != null && paint.getColorFilter() == null) {
            paint.setColorFilter((ColorFilter)this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        canvas.drawPath(Util.Companion.roundedRect(this.mBoundsF, this.mRadius, this.mRadius, this.topLeft, this.topRight, this.bottomRight, this.bottomLeft), paint);
        if (clearColorFilter) {
            paint.setColorFilter((ColorFilter)null);
        }
    }

    private final float calculateVerticalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
        return addPaddingForCorners ? (float)((double)(maxShadowSize * 1.5f) + 0.47467801200000004 * (double)cornerRadius) : maxShadowSize * 1.5f;
    }

    private final float calculateHorizontalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
        return addPaddingForCorners ? (float)((double)maxShadowSize + 0.47467801200000004 * (double)cornerRadius) : maxShadowSize;
    }

    private final void updateBounds(Rect bounds) {
        Rect bounds2 = bounds;
        if (bounds2 == null) {
            bounds2 = this.getBounds();
        }
        Rect rect = bounds2;
        if (rect == null) {
            Intrinsics.throwNpe();
        }
        this.mBoundsF.set((float)rect.left, (float)bounds2.top, (float)bounds2.right, (float)bounds2.bottom);
        this.mBoundsI.set(bounds2);
        if (this.mInsetForPadding) {
            float vInset = this.calculateVerticalPadding(this.padding, this.mRadius, this.mInsetForRadius);
            float hInset = this.calculateHorizontalPadding(this.padding, this.mRadius, this.mInsetForRadius);
            double d = hInset;
            Rect rect2 = this.mBoundsI;
            boolean bl = false;
            double d2 = Math.ceil(d);
            d = vInset;
            int n = (int)d2;
            bl = false;
            double d3 = Math.ceil(d);
            rect2.inset(n, (int)d3);
            this.mBoundsF.set(this.mBoundsI);
        }
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.updateBounds(bounds);
    }

    public void getOutline(@NotNull Outline outline) {
        Intrinsics.checkParameterIsNotNull((Object)outline, (String)"outline");
        outline.setConvexPath(Util.Companion.roundedRect(this.mBoundsF, this.mRadius, this.mRadius, this.topLeft, this.topRight, this.bottomRight, this.bottomLeft));
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(@NotNull ColorFilter cf) {
        Intrinsics.checkParameterIsNotNull((Object)cf, (String)"cf");
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public final float getRadius() {
        return this.mRadius;
    }

    public final void setRadius(float radius) {
        if (radius == this.mRadius) {
            return;
        }
        this.mRadius = radius;
        this.updateBounds(null);
        this.invalidateSelf();
    }

    @Nullable
    public final ColorStateList getColor() {
        return this.mBackground;
    }

    public final void setColor(@Nullable ColorStateList color) {
        this.setBackground(color);
        this.invalidateSelf();
    }

    public void setTintList(@NotNull ColorStateList tint) {
        Intrinsics.checkParameterIsNotNull((Object)tint, (String)"tint");
        this.mTint = tint;
        this.mTintFilter = this.createTintFilter(this.mTint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(@NotNull PorterDuff.Mode tintMode) {
        Intrinsics.checkParameterIsNotNull((Object)tintMode, (String)"tintMode");
        this.mTintMode = tintMode;
        this.mTintFilter = this.createTintFilter(this.mTint, this.mTintMode);
        this.invalidateSelf();
    }

    protected boolean onStateChange(@NotNull int[] stateSet) {
        int newColor;
        boolean colorChanged;
        Intrinsics.checkParameterIsNotNull((Object)stateSet, (String)"stateSet");
        ColorStateList colorStateList = this.mBackground;
        if (colorStateList == null) {
            Intrinsics.throwNpe();
        }
        ColorStateList colorStateList2 = this.mBackground;
        if (colorStateList2 == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = colorChanged = (newColor = colorStateList.getColorForState(stateSet, colorStateList2.getDefaultColor())) != this.mPaint.getColor();
        if (colorChanged) {
            this.mPaint.setColor(newColor);
        }
        if (this.mTint != null && this.mTintMode != null) {
            this.mTintFilter = this.createTintFilter(this.mTint, this.mTintMode);
            return true;
        }
        return colorChanged;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        if (this.mTint != null) {
            ColorStateList colorStateList = this.mTint;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            if (colorStateList.isStateful()) return true;
        }
        if (this.mBackground != null) {
            ColorStateList colorStateList = this.mBackground;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            if (colorStateList.isStateful()) return true;
        }
        if (!super.isStateful()) return false;
        return true;
    }

    private final PorterDuffColorFilter createTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public RoundRectDrawable(@Nullable ColorStateList backgroundColor, float mRadius, boolean topLeft, boolean topRight, boolean bottomLeft, boolean bottomRight) {
        this.mRadius = mRadius;
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
        this.mPaint = new Paint(5);
        this.mInsetForRadius = true;
        this.mTintMode = PorterDuff.Mode.SRC_IN;
        this.setBackground(backgroundColor);
        this.mBoundsF = new RectF();
        this.mBoundsI = new Rect();
    }

    public /* synthetic */ RoundRectDrawable(ColorStateList colorStateList, float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        this(colorStateList, f, bl, bl2, bl3, bl4);
    }
}

