/*
 * Decompiled with CFR 0.152.
 */
package com.bosong.frescozoomablelib.zoomable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.support.annotation.Nullable;
import android.view.animation.DecelerateInterpolator;
import com.bosong.frescozoomablelib.gestures.TransformGestureDetector;
import com.bosong.frescozoomablelib.zoomable.AbstractAnimatedZoomableController;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;

public class AnimatedZoomableController
extends AbstractAnimatedZoomableController {
    private static final Class<?> TAG = AnimatedZoomableController.class;
    private final ValueAnimator mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});

    public static AnimatedZoomableController newInstance() {
        return new AnimatedZoomableController(TransformGestureDetector.newInstance());
    }

    @SuppressLint(value={"NewApi"})
    public AnimatedZoomableController(TransformGestureDetector transformGestureDetector) {
        super(transformGestureDetector);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTransformAnimated(Matrix newTransform, long durationMs, final @Nullable Runnable onAnimationComplete) {
        FLog.v(this.getLogTag(), (String)"setTransformAnimated: duration %d ms", (Object)durationMs);
        this.stopAnimation();
        Preconditions.checkArgument((durationMs > 0L ? 1 : 0) != 0);
        Preconditions.checkState((!this.isAnimating() ? 1 : 0) != 0);
        this.setAnimating(true);
        this.mValueAnimator.setDuration(durationMs);
        this.getTransform().getValues(this.getStartValues());
        newTransform.getValues(this.getStopValues());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                AnimatedZoomableController.this.calculateInterpolation(AnimatedZoomableController.this.getWorkingTransform(), ((Float)valueAnimator.getAnimatedValue()).floatValue());
                AnimatedZoomableController.super.setTransform(AnimatedZoomableController.this.getWorkingTransform());
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                FLog.v(AnimatedZoomableController.this.getLogTag(), (String)"setTransformAnimated: animation cancelled");
                this.onAnimationStopped();
            }

            public void onAnimationEnd(Animator animation) {
                FLog.v(AnimatedZoomableController.this.getLogTag(), (String)"setTransformAnimated: animation finished");
                this.onAnimationStopped();
            }

            private void onAnimationStopped() {
                if (onAnimationComplete != null) {
                    onAnimationComplete.run();
                }
                AnimatedZoomableController.this.setAnimating(false);
                AnimatedZoomableController.this.getDetector().restartGesture();
            }
        });
        this.mValueAnimator.start();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void stopAnimation() {
        if (!this.isAnimating()) {
            return;
        }
        FLog.v(this.getLogTag(), (String)"stopAnimation");
        this.mValueAnimator.cancel();
        this.mValueAnimator.removeAllUpdateListeners();
        this.mValueAnimator.removeAllListeners();
    }

    @Override
    protected Class<?> getLogTag() {
        return TAG;
    }
}

