/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.event.ExceptionHandler;
import com.ironz.binaryprefs.exception.FileOperationException;
import java.util.concurrent.Future;

public final class FutureBarrier<T> {
    private final Future<T> future;
    private final ExceptionHandler exceptionHandler;

    FutureBarrier(Future<T> future, ExceptionHandler exceptionHandler) {
        this.future = future;
        this.exceptionHandler = exceptionHandler;
    }

    public void completeBlockingUnsafe() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }

    public T completeBlockingWihResult(T defValue) {
        try {
            return this.future.get();
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e);
            return defValue;
        }
    }

    public T completeBlockingWithResultUnsafe() {
        try {
            return this.future.get();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }

    public boolean completeBlockingWithStatus() {
        try {
            this.future.get();
            return true;
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e);
            return false;
        }
    }
}

