/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.candidates.CacheCandidateProvider;
import com.ironz.binaryprefs.cache.provider.CacheProvider;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.exception.TransactionInvalidatedException;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.strategy.SerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.BooleanSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.ByteArraySerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.ByteSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.CharSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.DoubleSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.FloatSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.IntegerSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.LongSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.PersistableSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.ShortSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.StringSerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.StringSetSerializationStrategy;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

final class BinaryPreferencesEditor
implements PreferencesEditor {
    private static final String TRANSACTED_TWICE_MESSAGE = "Transaction should be applied or committed only once!";
    private final Map<String, SerializationStrategy> strategyMap = new HashMap<String, SerializationStrategy>();
    private final Set<String> removeSet = new HashSet<String>();
    private final FileTransaction fileTransaction;
    private final EventBridge bridge;
    private final TaskExecutor taskExecutor;
    private final SerializerFactory serializerFactory;
    private final CacheProvider cacheProvider;
    private final CacheCandidateProvider candidateProvider;
    private final Lock writeLock;
    private boolean invalidated;

    BinaryPreferencesEditor(FileTransaction fileTransaction, EventBridge bridge, TaskExecutor taskExecutor, SerializerFactory serializerFactory, CacheProvider cacheProvider, CacheCandidateProvider candidateProvider, Lock writeLock) {
        this.fileTransaction = fileTransaction;
        this.bridge = bridge;
        this.taskExecutor = taskExecutor;
        this.serializerFactory = serializerFactory;
        this.cacheProvider = cacheProvider;
        this.candidateProvider = candidateProvider;
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putString(String key, String value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            StringSerializationStrategy strategy = new StringSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putStringSet(String key, Set<String> value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            StringSetSerializationStrategy strategy = new StringSetSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putInt(String key, int value) {
        this.writeLock.lock();
        try {
            IntegerSerializationStrategy strategy = new IntegerSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putLong(String key, long value) {
        this.writeLock.lock();
        try {
            LongSerializationStrategy strategy = new LongSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putFloat(String key, float value) {
        this.writeLock.lock();
        try {
            FloatSerializationStrategy strategy = new FloatSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putBoolean(String key, boolean value) {
        this.writeLock.lock();
        try {
            BooleanSerializationStrategy strategy = new BooleanSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistable> PreferencesEditor putPersistable(String key, T value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            PersistableSerializationStrategy strategy = new PersistableSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putByte(String key, byte value) {
        this.writeLock.lock();
        try {
            ByteSerializationStrategy strategy = new ByteSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putShort(String key, short value) {
        this.writeLock.lock();
        try {
            ShortSerializationStrategy strategy = new ShortSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putChar(String key, char value) {
        this.writeLock.lock();
        try {
            CharSerializationStrategy strategy = new CharSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putDouble(String key, double value) {
        this.writeLock.lock();
        try {
            DoubleSerializationStrategy strategy = new DoubleSerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putByteArray(String key, byte[] value) {
        this.writeLock.lock();
        try {
            ByteArraySerializationStrategy strategy = new ByteArraySerializationStrategy(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PreferencesEditor remove(String key) {
        this.writeLock.lock();
        try {
            this.removeSet.add(key);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PreferencesEditor clear() {
        this.writeLock.lock();
        try {
            Set<String> all = this.candidateProvider.keys();
            this.removeSet.addAll(all);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void apply() {
        this.writeLock.lock();
        try {
            this.performTransaction();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean commit() {
        this.writeLock.lock();
        try {
            FutureBarrier barrier = this.performTransaction();
            boolean bl = barrier.completeBlockingWithStatus();
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private FutureBarrier performTransaction() {
        this.removeCache();
        this.storeCache();
        this.invalidate();
        return this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BinaryPreferencesEditor.this.commitTransaction();
            }
        });
    }

    private void removeCache() {
        for (String name : this.removeSet) {
            this.candidateProvider.remove(name);
            this.cacheProvider.remove(name);
        }
    }

    private void storeCache() {
        for (String name : this.strategyMap.keySet()) {
            SerializationStrategy strategy = this.strategyMap.get(name);
            Object value = strategy.getValue();
            this.candidateProvider.put(name);
            this.cacheProvider.put(name, value);
        }
    }

    private void invalidate() {
        if (this.invalidated) {
            throw new TransactionInvalidatedException(TRANSACTED_TWICE_MESSAGE);
        }
        this.invalidated = true;
    }

    private void commitTransaction() {
        List<TransactionElement> transaction = this.createTransaction();
        this.fileTransaction.commit(transaction);
        this.notifyListeners(transaction);
    }

    private List<TransactionElement> createTransaction() {
        LinkedList<TransactionElement> elements = new LinkedList<TransactionElement>();
        elements.addAll(this.removePersistence());
        elements.addAll(this.storePersistence());
        return elements;
    }

    private List<TransactionElement> removePersistence() {
        LinkedList<TransactionElement> elements = new LinkedList<TransactionElement>();
        for (String name : this.removeSet) {
            TransactionElement e = TransactionElement.createRemovalElement(name);
            elements.add(e);
        }
        return elements;
    }

    private List<TransactionElement> storePersistence() {
        Set<String> strings = this.strategyMap.keySet();
        LinkedList<TransactionElement> elements = new LinkedList<TransactionElement>();
        for (String name : strings) {
            SerializationStrategy strategy = this.strategyMap.get(name);
            byte[] bytes = strategy.serialize();
            TransactionElement e = TransactionElement.createUpdateElement(name, bytes);
            elements.add(e);
        }
        return elements;
    }

    private void notifyListeners(List<TransactionElement> transaction) {
        for (TransactionElement element : transaction) {
            String name = element.getName();
            byte[] bytes = element.getContent();
            if (element.getAction() == 3) {
                this.bridge.notifyListenersRemove(name);
            }
            if (element.getAction() != 2) continue;
            this.bridge.notifyListenersUpdate(name, bytes);
        }
    }
}

