/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.strategy.SerializationStrategy;
import com.ironz.binaryprefs.serialization.strategy.impl.BooleanSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.ByteSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.CharSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.DoubleSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.FloatSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.IntegerSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.LongSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.PersistableSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.ShortSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.StringSerializationStrategyImpl;
import com.ironz.binaryprefs.serialization.strategy.impl.StringSetSerializationStrategyImpl;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

final class BinaryPreferencesEditor
implements PreferencesEditor {
    private final Map<String, SerializationStrategy> strategyMap = new HashMap<String, SerializationStrategy>(0);
    private final Set<String> removeSet = new HashSet<String>(0);
    private final FileTransaction fileTransaction;
    private final EventBridge bridge;
    private final TaskExecutor taskExecutor;
    private final SerializerFactory serializerFactory;
    private final CacheProvider cacheProvider;
    private final Lock writeLock;
    private boolean clear;

    BinaryPreferencesEditor(FileTransaction fileTransaction, EventBridge bridge, TaskExecutor taskExecutor, SerializerFactory serializerFactory, CacheProvider cacheProvider, Lock writeLock) {
        this.fileTransaction = fileTransaction;
        this.bridge = bridge;
        this.taskExecutor = taskExecutor;
        this.serializerFactory = serializerFactory;
        this.cacheProvider = cacheProvider;
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putString(String key, String value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            StringSerializationStrategyImpl strategy = new StringSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putStringSet(String key, Set<String> value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            StringSetSerializationStrategyImpl strategy = new StringSetSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putInt(String key, int value) {
        this.writeLock.lock();
        try {
            IntegerSerializationStrategyImpl strategy = new IntegerSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putLong(String key, long value) {
        this.writeLock.lock();
        try {
            LongSerializationStrategyImpl strategy = new LongSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putFloat(String key, float value) {
        this.writeLock.lock();
        try {
            FloatSerializationStrategyImpl strategy = new FloatSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putBoolean(String key, boolean value) {
        this.writeLock.lock();
        try {
            BooleanSerializationStrategyImpl strategy = new BooleanSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistable> PreferencesEditor putPersistable(String key, T value) {
        if (value == null) {
            return this.remove(key);
        }
        this.writeLock.lock();
        try {
            PersistableSerializationStrategyImpl strategy = new PersistableSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putByte(String key, byte value) {
        this.writeLock.lock();
        try {
            ByteSerializationStrategyImpl strategy = new ByteSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putShort(String key, short value) {
        this.writeLock.lock();
        try {
            ShortSerializationStrategyImpl strategy = new ShortSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putChar(String key, char value) {
        this.writeLock.lock();
        try {
            CharSerializationStrategyImpl strategy = new CharSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor putDouble(String key, double value) {
        this.writeLock.lock();
        try {
            DoubleSerializationStrategyImpl strategy = new DoubleSerializationStrategyImpl(value, this.serializerFactory);
            this.strategyMap.put(key, strategy);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.lock();
        }
    }

    @Override
    public PreferencesEditor remove(String key) {
        this.writeLock.lock();
        try {
            this.removeSet.add(key);
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PreferencesEditor clear() {
        this.writeLock.lock();
        try {
            this.clear = true;
            BinaryPreferencesEditor binaryPreferencesEditor = this;
            return binaryPreferencesEditor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void apply() {
        this.writeLock.lock();
        try {
            this.clearCache();
            this.removeCache();
            this.storeCache();
            this.taskExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    BinaryPreferencesEditor.this.commitTransaction();
                }
            });
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean commit() {
        this.writeLock.lock();
        try {
            this.clearCache();
            this.removeCache();
            this.storeCache();
            FutureBarrier barrier = this.taskExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    BinaryPreferencesEditor.this.commitTransaction();
                }
            });
            boolean bl = barrier.completeBlocking();
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearCache() {
        if (!this.clear) {
            return;
        }
        for (String name : this.cacheProvider.keys()) {
            this.cacheProvider.remove(name);
        }
    }

    private void removeCache() {
        if (this.clear) {
            return;
        }
        for (String name : this.removeSet) {
            this.cacheProvider.remove(name);
        }
    }

    private void storeCache() {
        for (String name : this.strategyMap.keySet()) {
            SerializationStrategy strategy = this.strategyMap.get(name);
            Object value = strategy.getValue();
            this.cacheProvider.put(name, value);
        }
    }

    private void commitTransaction() {
        List<TransactionElement> transaction = this.createTransaction();
        this.fileTransaction.commit(transaction);
        this.notifyListeners(transaction);
    }

    private List<TransactionElement> createTransaction() {
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>();
        elements.addAll(this.clearPersistence());
        elements.addAll(this.removePersistence());
        elements.addAll(this.storePersistence());
        return elements;
    }

    private List<TransactionElement> clearPersistence() {
        if (!this.clear) {
            return Collections.emptyList();
        }
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>();
        for (String name : this.cacheProvider.keys()) {
            TransactionElement e = TransactionElement.createRemovalElement(name);
            elements.add(e);
        }
        return elements;
    }

    private List<TransactionElement> removePersistence() {
        if (this.clear) {
            return Collections.emptyList();
        }
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>();
        for (String name : this.removeSet) {
            TransactionElement e = TransactionElement.createRemovalElement(name);
            elements.add(e);
        }
        return elements;
    }

    private List<TransactionElement> storePersistence() {
        Set<String> strings = this.strategyMap.keySet();
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>(strings.size());
        for (String name : strings) {
            SerializationStrategy strategy = this.strategyMap.get(name);
            byte[] bytes = strategy.serialize();
            TransactionElement e = TransactionElement.createUpdateElement(name, bytes);
            elements.add(e);
        }
        return elements;
    }

    private void notifyListeners(List<TransactionElement> transaction) {
        for (TransactionElement element : transaction) {
            String name = element.getName();
            byte[] bytes = element.getContent();
            if (element.getAction() == 2) {
                this.bridge.notifyListenersRemove(name);
            }
            if (element.getAction() != 1) continue;
            this.bridge.notifyListenersUpdate(name, bytes);
        }
    }
}

