/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import java.io.ByteArrayOutputStream;

final class Base64 {
    private static final char[] CHAR_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] BYTE_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    Base64() {
    }

    static String encode(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        int pad = 0;
        for (int i = 0; i < data.length; i += 3) {
            int b = (data[i] & 0xFF) << 16 & 0xFFFFFF;
            if (i + 1 < data.length) {
                b |= (data[i + 1] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i + 2 < data.length) {
                b |= data[i + 2] & 0xFF;
            } else {
                ++pad;
            }
            for (int j = 0; j < 4 - pad; ++j) {
                int c = (b & 0xFC0000) >> 18;
                buffer.append(CHAR_TABLE[c]);
                b <<= 6;
            }
        }
        for (int j = 0; j < pad; ++j) {
            buffer.append("=");
        }
        return buffer.toString();
    }

    static byte[] decode(String data) {
        byte[] bytes = data.getBytes();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int i = 0;
        while (i < bytes.length) {
            if (BYTE_TABLE[bytes[i]] == -1) {
                ++i;
                continue;
            }
            int b = (BYTE_TABLE[bytes[i]] & 0xFF) << 18;
            int num = 0;
            if (i + 1 < bytes.length && BYTE_TABLE[bytes[i + 1]] != -1) {
                b |= (BYTE_TABLE[bytes[i + 1]] & 0xFF) << 12;
                ++num;
            }
            if (i + 2 < bytes.length && BYTE_TABLE[bytes[i + 2]] != -1) {
                b |= (BYTE_TABLE[bytes[i + 2]] & 0xFF) << 6;
                ++num;
            }
            if (i + 3 < bytes.length && BYTE_TABLE[bytes[i + 3]] != -1) {
                b |= BYTE_TABLE[bytes[i + 3]] & 0xFF;
                ++num;
            }
            while (num > 0) {
                int c = (b & 0xFF0000) >> 16;
                buffer.write((char)c);
                b <<= 8;
                --num;
            }
            i += 4;
        }
        return buffer.toByteArray();
    }
}

