/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable.io;

import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.io.DataOutput;

public final class BinaryPrefsObjectOutputImpl
implements DataOutput {
    private static final int GROW_ARRAY_CAPACITY = 128;
    private final BooleanSerializer booleanSerializer;
    private final ByteSerializer byteSerializer;
    private final CharSerializer charSerializer;
    private final DoubleSerializer doubleSerializer;
    private final FloatSerializer floatSerializer;
    private final IntegerSerializer integerSerializer;
    private final LongSerializer longSerializer;
    private final ShortSerializer shortSerializer;
    private final StringSerializer stringSerializer;
    private int offset = 0;
    private byte[] buffer = new byte[128];

    public BinaryPrefsObjectOutputImpl(BooleanSerializer booleanSerializer, ByteSerializer byteSerializer, CharSerializer charSerializer, DoubleSerializer doubleSerializer, FloatSerializer floatSerializer, IntegerSerializer integerSerializer, LongSerializer longSerializer, ShortSerializer shortSerializer, StringSerializer stringSerializer) {
        this.booleanSerializer = booleanSerializer;
        this.byteSerializer = byteSerializer;
        this.charSerializer = charSerializer;
        this.doubleSerializer = doubleSerializer;
        this.floatSerializer = floatSerializer;
        this.integerSerializer = integerSerializer;
        this.longSerializer = longSerializer;
        this.shortSerializer = shortSerializer;
        this.stringSerializer = stringSerializer;
    }

    @Override
    public <T extends Persistable> byte[] serialize(T value) {
        this.write(new byte[]{-11});
        value.writeExternal(this);
        byte[] bytes = new byte[this.offset];
        System.arraycopy(this.buffer, 0, bytes, 0, this.offset);
        return bytes;
    }

    @Override
    public void writeBoolean(boolean value) {
        byte[] serialize = this.booleanSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeByte(int value) {
        byte[] serialize = this.byteSerializer.serialize((byte)value);
        this.write(serialize);
    }

    @Override
    public void writeShort(int value) {
        byte[] serialize = this.shortSerializer.serialize((short)value);
        this.write(serialize);
    }

    @Override
    public void writeChar(int value) {
        byte[] serialize = this.charSerializer.serialize((char)value);
        this.write(serialize);
    }

    @Override
    public void writeInt(int value) {
        byte[] serialize = this.integerSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeLong(long value) {
        byte[] serialize = this.longSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeFloat(float value) {
        byte[] serialize = this.floatSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeDouble(double value) {
        byte[] serialize = this.doubleSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeString(String value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        byte[] serialize = this.stringSerializer.serialize(value);
        int length = serialize.length - this.stringSerializer.bytesLength();
        this.writeInt(length);
        this.write(serialize);
    }

    private void write(byte[] value) {
        int length = value.length;
        this.tryGrowArray(length);
        System.arraycopy(value, 0, this.buffer, this.offset, length);
        this.offset += length;
    }

    private void tryGrowArray(int len) {
        if (this.offset + len >= this.buffer.length - 1) {
            this.growArray(len);
        }
    }

    private void growArray(int len) {
        int newLength = (this.buffer.length + len + 128) * 2;
        byte[] bytes = new byte[newLength];
        System.arraycopy(this.buffer, 0, bytes, 0, this.buffer.length);
        this.buffer = bytes;
    }
}

