/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.Context;
import android.os.Looper;
import com.ironz.binaryprefs.BinaryPreferences;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.ConcurrentCacheProviderImpl;
import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.events.BroadcastEventBridgeImpl;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.exception.PreferencesInitializationException;
import com.ironz.binaryprefs.file.adapter.NioFileAdapter;
import com.ironz.binaryprefs.file.directory.AndroidDirectoryProviderImpl;
import com.ironz.binaryprefs.file.transaction.MultiProcessTransactionImpl;
import com.ironz.binaryprefs.lock.SimpleLockFactoryImpl;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.PersistableRegistry;
import com.ironz.binaryprefs.task.ScheduledBackgroundTaskExecutor;

public final class BinaryPreferencesBuilder {
    private static final String DEFAULT_NAME = "default";
    private final Context context;
    private final PersistableRegistry persistableRegistry = new PersistableRegistry();
    private String name = "default";
    private boolean externalStorage = false;
    private ByteEncryption byteEncryption = ByteEncryption.NO_OP;
    private ExceptionHandler exceptionHandler = ExceptionHandler.PRINT;

    public BinaryPreferencesBuilder(Context context) {
        this.context = context;
    }

    public BinaryPreferencesBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BinaryPreferencesBuilder externalStorage(boolean value) {
        this.externalStorage = value;
        return this;
    }

    public BinaryPreferencesBuilder encryption(ByteEncryption byteEncryption) {
        this.byteEncryption = byteEncryption;
        return this;
    }

    public BinaryPreferencesBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BinaryPreferencesBuilder registerPersistable(String key, Class<? extends Persistable> persistable) {
        this.persistableRegistry.register(key, persistable);
        return this;
    }

    public Preferences build() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new PreferencesInitializationException("Preferences instantiated not in the main thread.");
        }
        AndroidDirectoryProviderImpl directoryProvider = new AndroidDirectoryProviderImpl(this.context, this.name, this.externalStorage);
        NioFileAdapter fileAdapter = new NioFileAdapter(directoryProvider);
        SimpleLockFactoryImpl lockFactory = new SimpleLockFactoryImpl(this.name, directoryProvider);
        MultiProcessTransactionImpl fileTransaction = new MultiProcessTransactionImpl(fileAdapter, lockFactory);
        ConcurrentCacheProviderImpl cacheProvider = new ConcurrentCacheProviderImpl(this.name);
        ScheduledBackgroundTaskExecutor executor = new ScheduledBackgroundTaskExecutor(this.name, this.exceptionHandler);
        SerializerFactory serializerFactory = new SerializerFactory(this.persistableRegistry);
        BroadcastEventBridgeImpl eventsBridge = new BroadcastEventBridgeImpl(this.context, this.name, cacheProvider, serializerFactory, executor, this.byteEncryption);
        BinaryPreferences preferences = new BinaryPreferences(fileTransaction, this.byteEncryption, eventsBridge, cacheProvider, executor, serializerFactory, lockFactory);
        eventsBridge.definePreferences(preferences);
        return preferences;
    }
}

