/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file.transaction;

import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.file.adapter.FileAdapter;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.lock.LockFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;

public final class MultiProcessTransactionImpl
implements FileTransaction {
    private final FileAdapter fileAdapter;
    private final LockFactory lockFactory;
    private final ValueEncryption valueEncryption;
    private final KeyEncryption keyEncryption;

    public MultiProcessTransactionImpl(FileAdapter fileAdapter, LockFactory lockFactory, ValueEncryption valueEncryption, KeyEncryption keyEncryption) {
        this.fileAdapter = fileAdapter;
        this.lockFactory = lockFactory;
        this.valueEncryption = valueEncryption;
        this.keyEncryption = keyEncryption;
    }

    @Override
    public List<TransactionElement> fetch() {
        Lock lock = this.lockFactory.getProcessLock();
        lock.lock();
        try {
            List<TransactionElement> list = this.fetchInternal();
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void commit(List<TransactionElement> elements) {
        Lock lock = this.lockFactory.getProcessLock();
        lock.lock();
        try {
            this.commitInternal(elements);
        }
        finally {
            lock.unlock();
        }
    }

    private List<TransactionElement> fetchInternal() {
        String[] names = this.fileAdapter.names();
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>(names.length);
        for (String name : names) {
            byte[] bytes = this.fileAdapter.fetch(name);
            byte[] decrypt = this.valueEncryption.decrypt(bytes);
            String encryptName = this.keyEncryption.encrypt(name);
            TransactionElement element = TransactionElement.createFetchElement(encryptName, decrypt);
            elements.add(element);
        }
        return elements;
    }

    private void commitInternal(List<TransactionElement> elements) {
        for (TransactionElement element : elements) {
            int action = element.getAction();
            String encryptedName = this.keyEncryption.encrypt(element.getName());
            byte[] content = element.getContent();
            byte[] encrypt = this.valueEncryption.encrypt(content);
            if (action == 1) {
                this.fileAdapter.save(encryptedName, content);
            }
            if (action != 2) continue;
            this.fileAdapter.remove(encryptedName);
        }
    }
}

