/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.exception.EncryptionException;
import java.util.Arrays;

public final class XorKeyEncryptionImpl
implements KeyEncryption {
    private static final String SMALL_XOR_MESSAGE = "XOR must be at least 16 bytes";
    private static final String MIRRORED_XOR_MESSAGE = "XOR must not be mirrored";
    private static final int KEY_LENGTH = 16;
    private final byte[] xor;

    public XorKeyEncryptionImpl(byte[] xor) {
        this.xor = xor;
        this.checkLength();
        this.checkMirror();
    }

    @Override
    public String decrypt(String name) {
        return this.xorName(name);
    }

    @Override
    public String encrypt(String name) {
        return this.xorName(name);
    }

    private String xorName(String name) {
        byte[] original = name.getBytes();
        int length = original.length;
        byte[] result = new byte[length];
        for (int index = 0; index < length; ++index) {
            byte b = original[index];
            result[index] = this.xorByte(b);
        }
        return new String(result);
    }

    private byte xorByte(byte raw) {
        byte temp = raw;
        for (byte b : this.xor) {
            temp = (byte)(temp ^ b);
        }
        return temp;
    }

    private void checkMirror() {
        if (!this.isEven()) {
            return;
        }
        int half = this.xor.length / 2;
        byte[] firstHalf = Arrays.copyOfRange(this.xor, 0, half);
        byte[] secondHalf = Arrays.copyOfRange(this.xor, half, this.xor.length);
        Arrays.sort(firstHalf);
        Arrays.sort(secondHalf);
        if (Arrays.equals(firstHalf, secondHalf)) {
            throw new EncryptionException(MIRRORED_XOR_MESSAGE);
        }
    }

    private boolean isEven() {
        return this.xor.length % 2 == 0;
    }

    private void checkLength() {
        if (this.xor.length < 16) {
            throw new EncryptionException(SMALL_XOR_MESSAGE);
        }
    }
}

