/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.exception.EncryptionException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesValueEncryptionImpl
implements ValueEncryption {
    private static final String SHORT_KEYS_MESSAGE = "Secret and initial vector must be 16 bytes";
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5PADDING";
    private static final int KEY_LENGTH = 16;
    private final Cipher cipher;
    private final SecretKeySpec keySpec;
    private final IvParameterSpec iv;

    public AesValueEncryptionImpl(byte[] secretKeyBytes, byte[] initialVector) {
        this.checkLength(secretKeyBytes, initialVector);
        this.cipher = this.getCipherInstance();
        this.keySpec = new SecretKeySpec(secretKeyBytes, AES);
        this.iv = new IvParameterSpec(initialVector);
    }

    private void checkLength(byte[] secretKeyBytes, byte[] initialVector) {
        if (secretKeyBytes.length != 16 || initialVector.length != 16) {
            throw new EncryptionException(SHORT_KEYS_MESSAGE);
        }
    }

    private Cipher getCipherInstance() {
        try {
            return Cipher.getInstance(AES_CBC_PKCS5_PADDING);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        return this.encryptInternal(bytes);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        return this.decryptInternal(bytes);
    }

    private byte[] encryptInternal(byte[] bytes) {
        try {
            Cipher encryptCipher = this.createEncryptCipher();
            return encryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private byte[] decryptInternal(byte[] bytes) {
        try {
            Cipher decryptCipher = this.createDecryptCipher();
            return decryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private Cipher createEncryptCipher() throws Exception {
        this.cipher.init(1, (Key)this.keySpec, this.iv);
        return this.cipher;
    }

    private Cipher createDecryptCipher() throws Exception {
        this.cipher.init(2, (Key)this.keySpec, this.iv);
        return this.cipher;
    }
}

