/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.lock;

import com.ironz.binaryprefs.exception.FileOperationException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class ProcessFileLock
implements Lock {
    private static final String RWD_MODE = "rwd";
    private final File lockFile;
    private RandomAccessFile randomAccessFile;
    private FileChannel channel;
    private FileLock lock;

    ProcessFileLock(File lockFile) {
        this.lockFile = lockFile;
    }

    @Override
    public void lock() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.lockFile, RWD_MODE);
            this.channel = this.randomAccessFile.getChannel();
            if (!this.lockFile.exists()) {
                this.randomAccessFile.seek(0L);
                this.randomAccessFile.write(0);
            }
            this.lock = this.channel.lock();
        }
        catch (Exception e) {
            throw new FileOperationException("Exception while acquire lock", e);
        }
    }

    @Override
    public void unlock() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            throw new FileOperationException("Exception while release lock", e);
        }
        finally {
            try {
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

