/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable;

import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import java.util.HashMap;
import java.util.Map;

public final class PersistableRegistry {
    private final Map<String, Class<? extends Persistable>> map = new HashMap<String, Class<? extends Persistable>>();

    public void register(String token, Class<? extends Persistable> clazz) {
        if (this.map.containsKey(token)) {
            throw new UnsupportedOperationException(String.format("Registry already contains '%s' class for '%s' token.", clazz.getName(), token));
        }
        this.map.put(token, clazz);
    }

    public Class<? extends Persistable> get(String token) {
        if (!this.map.containsKey(token)) {
            throw new UnsupportedClassVersionError(String.format("Cannot find class type for '%s' token. Please, add token and type in 'register' method.", token));
        }
        return this.map.get(token);
    }

    public void remove(String token) {
        this.map.remove(token);
    }
}

