/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.lock;

import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.lock.ProcessFileLock;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SimpleLockFactoryImpl
implements LockFactory {
    private static final String LOCK_EXTENSION = ".lock";
    private static final Map<String, ReadWriteLock> locks = new ConcurrentHashMap<String, ReadWriteLock>();
    private final Map<String, Lock> processLocks = new ConcurrentHashMap<String, Lock>();
    private final String name;
    private final File lockDirectory;

    public SimpleLockFactoryImpl(String name, DirectoryProvider directoryProvider) {
        this.name = name;
        this.lockDirectory = directoryProvider.getLockDirectory();
        this.init(name);
    }

    private void init(String name) {
        this.initLocalLocks(name);
        this.initProcessLocks(name);
    }

    private void initLocalLocks(String name) {
        if (locks.containsKey(name)) {
            return;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        locks.put(name, lock);
    }

    private void initProcessLocks(String name) {
        if (this.processLocks.containsKey(name)) {
            return;
        }
        File lockFile = new File(this.lockDirectory, name + LOCK_EXTENSION);
        ProcessFileLock fileLock = new ProcessFileLock(lockFile);
        this.processLocks.put(name, fileLock);
    }

    @Override
    public Lock getReadLock() {
        ReadWriteLock readWriteLock = locks.get(this.name);
        return readWriteLock.readLock();
    }

    @Override
    public Lock getWriteLock() {
        ReadWriteLock readWriteLock = locks.get(this.name);
        return readWriteLock.writeLock();
    }

    @Override
    public Lock getProcessLock() {
        return this.processLocks.get(this.name);
    }
}

