/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Process;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.events.EventBridge;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class BroadcastEventBridgeImpl
implements EventBridge {
    private static final String INTENT_PREFIX = "com.ironz.binaryprefs.";
    private static final String ACTION_PREFERENCE_UPDATED = "com.ironz.binaryprefs.ACTION_PREFERENCE_UPDATED_";
    private static final String ACTION_PREFERENCE_REMOVED = "com.ironz.binaryprefs.ACTION_PREFERENCE_REMOVED_";
    private static final String PREFERENCE_NAME = "preference_name";
    private static final String PREFERENCE_KEY = "preference_key";
    private static final String PREFERENCE_VALUE = "preference_value";
    private static final String PREFERENCE_PROCESS_ID = "preference_process_id";
    private static final Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners = new ConcurrentHashMap<String, List<SharedPreferences.OnSharedPreferenceChangeListener>>();
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
    private final Handler handler = new Handler();
    private final Context context;
    private final String prefName;
    private final CacheProvider cacheProvider;
    private final SerializerFactory serializerFactory;
    private final TaskExecutor taskExecutor;
    private final ByteEncryption byteEncryption;
    private final String updateActionName;
    private final String removeActionName;
    private final int processId;
    private Preferences preferences;

    public BroadcastEventBridgeImpl(Context context, String prefName, CacheProvider cacheProvider, SerializerFactory serializerFactory, TaskExecutor taskExecutor, ByteEncryption byteEncryption) {
        this.context = context;
        this.prefName = prefName;
        this.cacheProvider = cacheProvider;
        this.serializerFactory = serializerFactory;
        this.taskExecutor = taskExecutor;
        this.byteEncryption = byteEncryption;
        this.updateActionName = ACTION_PREFERENCE_UPDATED + context.getPackageName();
        this.removeActionName = ACTION_PREFERENCE_REMOVED + context.getPackageName();
        this.listeners = this.initListeners(prefName);
        this.context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyUpdate(intent);
            }
        }, new IntentFilter(this.updateActionName));
        this.context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                BroadcastEventBridgeImpl.this.notifyRemove(intent);
            }
        }, new IntentFilter(this.removeActionName));
        this.processId = Process.myPid();
    }

    private List<SharedPreferences.OnSharedPreferenceChangeListener> initListeners(String prefName) {
        if (allListeners.containsKey(prefName)) {
            return allListeners.get(prefName);
        }
        ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
        allListeners.put(prefName, listeners);
        return listeners;
    }

    private void notifyUpdate(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (this.processId == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        final String key = intent.getStringExtra(PREFERENCE_KEY);
        final byte[] value = intent.getByteArrayExtra(PREFERENCE_VALUE);
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.notifyUpdateInternal(key, value);
            }
        });
    }

    private void notifyUpdateInternal(String key, byte[] value) {
        Object o = this.fetchObject(key, value);
        this.update(key, o);
    }

    private void notifyRemove(final Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        if (this.processId == intent.getIntExtra(PREFERENCE_PROCESS_ID, 0)) {
            return;
        }
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.notifyRemoveInternal(intent);
            }
        });
    }

    private void notifyRemoveInternal(Intent intent) {
        String key = intent.getStringExtra(PREFERENCE_KEY);
        this.remove(key);
    }

    private Object fetchObject(String key, byte[] bytes) {
        byte[] decrypt = this.byteEncryption.decrypt(bytes);
        return this.serializerFactory.deserialize(key, decrypt);
    }

    public void definePreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListenersUpdate(Preferences preferences, String key, byte[] bytes) {
        Object o = this.fetchObject(key, bytes);
        this.update(key, o);
        this.sendUpdateIntent(key, bytes);
    }

    @Override
    public void notifyListenersRemove(Preferences preferences, String key) {
        this.remove(key);
        this.sendRemoveIntent(key);
    }

    private void update(String key, Object value) {
        this.cacheProvider.put(key, value);
        this.notifyListeners(key);
    }

    private void remove(String key) {
        this.cacheProvider.remove(key);
        this.notifyListeners(key);
    }

    private void notifyListeners(final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : BroadcastEventBridgeImpl.this.listeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)BroadcastEventBridgeImpl.this.preferences, key);
                }
            }
        });
    }

    private void sendUpdateIntent(final String key, final byte[] bytes) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.sendUpdateIntentInternal(key, bytes);
            }
        });
    }

    private void sendRemoveIntent(final String key) {
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BroadcastEventBridgeImpl.this.sendRemoveIntentInternal(key);
            }
        });
    }

    private void sendUpdateIntentInternal(String key, byte[] bytes) {
        Intent intent = new Intent(this.updateActionName);
        intent.putExtra(PREFERENCE_PROCESS_ID, this.processId);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        intent.putExtra(PREFERENCE_VALUE, bytes);
        this.context.sendBroadcast(intent);
    }

    private void sendRemoveIntentInternal(String key) {
        Intent intent = new Intent(this.removeActionName);
        intent.putExtra(PREFERENCE_PROCESS_ID, this.processId);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        this.context.sendBroadcast(intent);
    }
}

