/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.SharedPreferences;
import android.os.Handler;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.events.EventBridge;
import java.util.ArrayList;
import java.util.List;

public final class MainThreadEventBridgeImpl
implements EventBridge {
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private final Handler handler = new Handler();
    private final CacheProvider cacheProvider;

    public MainThreadEventBridgeImpl(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListenersUpdate(Preferences preferences, String key, Object value) {
        this.cacheProvider.put(key, value);
        this.notifyListeners(preferences, key);
    }

    @Override
    public void notifyListenersRemove(Preferences preferences, String key) {
        this.cacheProvider.remove(key);
        this.notifyListeners(preferences, key);
    }

    private void notifyListeners(final Preferences preferences, final String key) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : MainThreadEventBridgeImpl.this.listeners) {
                    listener.onSharedPreferenceChanged((SharedPreferences)preferences, key);
                }
            }
        });
    }
}

