/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.text.DecimalFormat;

public class StringConverter {
    private static DecimalFormat mMoneyFormatter = new DecimalFormat("0.00");
    private static DecimalFormat mMoneyFormatterNoDecimal = new DecimalFormat("0");
    private static DecimalFormat mDistanceFormatterKM = new DecimalFormat("0.0");
    private static DecimalFormat mDistanceFormatterM = new DecimalFormat("0");

    public static String dayToEnglish(int day) {
        switch (day) {
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
            case 1: {
                return "Sunday";
            }
        }
        return null;
    }

    public static String dayToChineseZhou(int day) {
        switch (day) {
            case 2: {
                return "\u5468\u4e00";
            }
            case 3: {
                return "\u5468\u4e8c";
            }
            case 4: {
                return "\u5468\u4e09";
            }
            case 5: {
                return "\u5468\u56db";
            }
            case 6: {
                return "\u5468\u4e94";
            }
            case 7: {
                return "\u5468\u516d";
            }
            case 1: {
                return "\u5468\u65e5";
            }
        }
        return null;
    }

    public static String dayToChineseXingQi(int day) {
        switch (day) {
            case 2: {
                return "\u661f\u671f\u4e00";
            }
            case 3: {
                return "\u661f\u671f\u4e8c";
            }
            case 4: {
                return "\u661f\u671f\u4e09";
            }
            case 5: {
                return "\u661f\u671f\u56db";
            }
            case 6: {
                return "\u661f\u671f\u4e94";
            }
            case 7: {
                return "\u661f\u671f\u516d";
            }
            case 1: {
                return "\u661f\u671f\u5929";
            }
        }
        return null;
    }

    public static String monthToEnglish(int month) {
        switch (month) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return null;
    }

    public static String monthToChinese(int month) {
        switch (month) {
            case 0: {
                return "\u4e00\u6708";
            }
            case 1: {
                return "\u4e8c\u6708";
            }
            case 2: {
                return "\u4e09\u6708";
            }
            case 3: {
                return "\u56db\u6708";
            }
            case 4: {
                return "\u4e94\u6708";
            }
            case 5: {
                return "\u516d\u6708";
            }
            case 6: {
                return "\u4e03\u6708";
            }
            case 7: {
                return "\u516b\u6708";
            }
            case 8: {
                return "\u4e5d\u6708";
            }
            case 9: {
                return "\u5341\u6708";
            }
            case 10: {
                return "\u5341\u4e00\u6708";
            }
            case 11: {
                return "\u5341\u4e8c\u6708";
            }
        }
        return null;
    }

    public static String money(double value) {
        return mMoneyFormatter.format(value);
    }

    public static String money(String value) {
        return mMoneyFormatter.format(value);
    }

    public static String moneyNoDecimal(double value) {
        return mMoneyFormatterNoDecimal.format(value);
    }

    public static String moneyNoDecimal(String value) {
        return mMoneyFormatterNoDecimal.format(value);
    }

    public static String distanceToEnglish(double km) {
        if (km >= 1.0) {
            return mDistanceFormatterKM.format(km) + "km";
        }
        return mDistanceFormatterM.format(km * 1000.0) + "m";
    }

    public static String distanceToChineseQianMi(double km) {
        if (km >= 1.0) {
            return mDistanceFormatterKM.format(km) + "\u5343\u7c73";
        }
        return mDistanceFormatterM.format(km * 1000.0) + "\u7c73";
    }

    public static String distanceToChineseGongLi(double km) {
        if (km >= 1.0) {
            return mDistanceFormatterKM.format(km) + "\u516c\u91cc";
        }
        return mDistanceFormatterM.format(km * 1000.0) + "\u7c73";
    }

    public static String numberToChineseNumber(int n) {
        switch (n) {
            case 0: {
                return "\u96f6";
            }
            case 1: {
                return "\u4e00";
            }
            case 2: {
                return "\u4e8c";
            }
            case 3: {
                return "\u4e09";
            }
            case 4: {
                return "\u56db";
            }
            case 5: {
                return "\u4e94";
            }
            case 6: {
                return "\u516d";
            }
            case 7: {
                return "\u4e03";
            }
            case 8: {
                return "\u516b";
            }
            case 9: {
                return "\u4e5d";
            }
        }
        return null;
    }
}

