/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SecurityHelper {
    private static final String AES_ALGORITHM = "AES";
    private static final String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String TRIPLE_DES_ALGORITHM = "DESede";
    private static final String TRIPLE_DES_TRANSFORMATION = "DESede/ECB/PKCS5Padding";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String RSA_TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    public static final int KEY_TYPE_X509 = 0;
    public static final int KEY_TYPE_PKCS8 = 1;

    public static byte[] md5(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] sha1(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return messageDigest.digest(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public static byte[] aesEncrypt(byte[] data, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION);
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] aesDecrypt(byte[] data, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION);
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] tripleDESEncrypt(byte[] data, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, TRIPLE_DES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(TRIPLE_DES_TRANSFORMATION);
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] tripleDESDecrypt(byte[] data, byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, TRIPLE_DES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(TRIPLE_DES_TRANSFORMATION);
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static KeySpec getKeySpec(byte[] key, int keyType) {
        switch (keyType) {
            case 0: {
                return new X509EncodedKeySpec(key);
            }
            case 1: {
                return new PKCS8EncodedKeySpec(key);
            }
        }
        return null;
    }

    public static byte[] rsaEncryptPublicKey(byte[] data, byte[] publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
            cipher.init(1, rsaPublicKey);
            ByteArrayOutputStream dstStream = new ByteArrayOutputStream();
            BigInteger modulus = rsaPublicKey.getModulus();
            int keyLength = modulus.bitLength();
            int dataBlockSize = keyLength / 8 - 11;
            for (int offset = 0; offset < data.length; offset += dataBlockSize) {
                int count = dataBlockSize;
                if (count + offset > data.length) {
                    count = data.length - offset;
                }
                byte[] dstPart = cipher.doFinal(data, offset, count);
                dstStream.write(dstPart);
            }
            return dstStream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] rsaDecryptPrivateKey(byte[] data, byte[] privateKey, int keyType) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            KeySpec keySpec = SecurityHelper.getKeySpec(privateKey, keyType);
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
            cipher.init(2, rsaPrivateKey);
            ByteArrayOutputStream dstStream = new ByteArrayOutputStream();
            BigInteger modulus = rsaPrivateKey.getModulus();
            int keyLength = modulus.bitLength();
            int dataBlockSize = keyLength / 8;
            for (int offset = 0; offset < data.length; offset += dataBlockSize) {
                int count = dataBlockSize;
                if (count + offset > data.length) {
                    count = data.length - offset;
                }
                byte[] dstPart = cipher.doFinal(data, offset, count);
                dstStream.write(dstPart);
            }
            return dstStream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] rsaEncryptPrivateKey(byte[] data, byte[] privateKey, int keyType) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            KeySpec keySpec = SecurityHelper.getKeySpec(privateKey, keyType);
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
            cipher.init(1, rsaPrivateKey);
            ByteArrayOutputStream dstStream = new ByteArrayOutputStream();
            BigInteger modulus = rsaPrivateKey.getModulus();
            int keyLength = modulus.bitLength();
            int dataBlockSize = keyLength / 8 - 11;
            for (int offset = 0; offset < data.length; offset += dataBlockSize) {
                int count = dataBlockSize;
                if (count + offset > data.length) {
                    count = data.length - offset;
                }
                byte[] dstPart = cipher.doFinal(data, offset, count);
                dstStream.write(dstPart);
            }
            return dstStream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] rsaDecryptPublicKey(byte[] data, byte[] publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION);
            cipher.init(2, rsaPublicKey);
            ByteArrayOutputStream dstStream = new ByteArrayOutputStream();
            BigInteger modulus = rsaPublicKey.getModulus();
            int keyLength = modulus.bitLength();
            int dataBlockSize = keyLength / 8;
            for (int offset = 0; offset < data.length; offset += dataBlockSize) {
                int count = dataBlockSize;
                if (count + offset > data.length) {
                    count = data.length - offset;
                }
                byte[] dstPart = cipher.doFinal(data, offset, count);
                dstStream.write(dstPart);
            }
            return dstStream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }
}

