/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import site.iway.javahelpers.CharHelper;
import site.iway.javahelpers.FileSystemHelper;
import site.iway.javahelpers.PrefsMap;
import site.iway.javahelpers.SerializableRW;

public class Prefs {
    private final File mPrefsFile;
    private final File mPrefsFileTemp;
    private final String mKey;
    private final ConcurrentHashMap<String, Object> mItems;
    private final AtomicBoolean mWillCommit;
    private final Object mCommitWaiter;
    private final Thread mCommitter;

    public Prefs(String prefsFile, String key) {
        this.mPrefsFile = new File(prefsFile);
        this.mPrefsFileTemp = new File(prefsFile + ".tmp");
        if (key != null) {
            int keyLength = key.length();
            if (keyLength == 24) {
                for (int i = 0; i < keyLength; ++i) {
                    if (CharHelper.isASCII(key.charAt(i))) continue;
                    throw new RuntimeException("The key can only be ascii codes.");
                }
            } else {
                throw new RuntimeException("The key length must be 24 if provided.");
            }
        }
        this.mKey = key;
        Serializable serializable = null;
        if (this.mPrefsFileTemp.exists()) {
            serializable = SerializableRW.read(this.mPrefsFileTemp, this.mKey);
        }
        if (serializable == null && this.mPrefsFile.exists()) {
            serializable = SerializableRW.read(this.mPrefsFile, this.mKey);
        }
        this.mItems = serializable instanceof PrefsMap ? (PrefsMap)serializable : new PrefsMap();
        this.mWillCommit = new AtomicBoolean();
        this.mCommitWaiter = new Object();
        this.mCommitter = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    if (Prefs.this.mWillCommit.compareAndSet(true, false)) {
                        do {
                            try {
                                1.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (Prefs.this.mWillCommit.compareAndSet(true, false));
                        PrefsMap copiedItems = new PrefsMap(Prefs.this.mItems);
                        if (!SerializableRW.write(Prefs.this.mPrefsFileTemp, Prefs.this.mKey, (Serializable)copiedItems) || !FileSystemHelper.copyFile(Prefs.this.mPrefsFileTemp, Prefs.this.mPrefsFile) || Prefs.this.mPrefsFileTemp.delete()) continue;
                        Prefs.this.mPrefsFileTemp.deleteOnExit();
                        continue;
                    }
                    try {
                        Object object = Prefs.this.mCommitWaiter;
                        synchronized (object) {
                            Prefs.this.mCommitWaiter.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        this.mCommitter.start();
    }

    public Prefs(String prefsFile) {
        this(prefsFile, null);
    }

    private String buildRealKey(String key, Class valueClass) {
        String className = valueClass.getSimpleName();
        return className + ":" + key;
    }

    private <T extends Serializable> T getObject(String key, Class<T> valueClass, T defValue) {
        String realKey = this.buildRealKey(key, valueClass);
        Object value = this.mItems.get(realKey);
        return (T)(value == null ? defValue : (Serializable)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyItemChanged() {
        this.mWillCommit.set(true);
        Object object = this.mCommitWaiter;
        synchronized (object) {
            this.mCommitWaiter.notify();
        }
    }

    private <T extends Serializable> void putObject(String key, T value) {
        if (key == null) {
            throw new NullPointerException("The specified key or value is null.");
        }
        if (value == null) {
            this.remove(key);
        } else {
            Class<?> valueClass = value.getClass();
            String realKey = this.buildRealKey(key, valueClass);
            Object oldValue = this.mItems.put(realKey, value);
            if (oldValue == null || !oldValue.equals(value)) {
                this.notifyItemChanged();
            }
        }
    }

    public boolean contains(String key) {
        return this.mItems.containsKey(key);
    }

    public void remove(String key) {
        Object oldValue = this.mItems.remove(key);
        if (oldValue != null) {
            this.notifyItemChanged();
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.getObject(key, Boolean.class, defValue);
    }

    public void putBoolean(String key, boolean value) {
        this.putObject(key, value);
    }

    public boolean[] getBooleanArray(String key, boolean[] defValue) {
        return this.getObject(key, boolean[].class, defValue);
    }

    public void putBooleanArray(String key, boolean[] value) {
        this.putObject(key, value);
    }

    public byte getByte(String key, byte defValue) {
        return this.getObject(key, Byte.class, defValue);
    }

    public void putByte(String key, byte value) {
        this.putObject(key, value);
    }

    public byte[] getByteArray(String key, byte[] defValue) {
        return this.getObject(key, byte[].class, defValue);
    }

    public void putByteArray(String key, byte[] value) {
        this.putObject(key, value);
    }

    public short getShort(String key, short defValue) {
        return this.getObject(key, Short.class, defValue);
    }

    public void putShort(String key, short value) {
        this.putObject(key, value);
    }

    public short[] getShortArray(String key, short[] defValue) {
        return this.getObject(key, short[].class, defValue);
    }

    public void putShortArray(String key, short[] value) {
        this.putObject(key, value);
    }

    public char getChar(String key, char defValue) {
        return this.getObject(key, Character.class, Character.valueOf(defValue)).charValue();
    }

    public void putChar(String key, char value) {
        this.putObject(key, Character.valueOf(value));
    }

    public char[] getCharArray(String key, char[] defValue) {
        return this.getObject(key, char[].class, defValue);
    }

    public void putCharArray(String key, char[] value) {
        this.putObject(key, value);
    }

    public float getFloat(String key, float defValue) {
        return this.getObject(key, Float.class, Float.valueOf(defValue)).floatValue();
    }

    public void putFloat(String key, float value) {
        this.putObject(key, Float.valueOf(value));
    }

    public float[] getFloatArray(String key, float[] defValue) {
        return this.getObject(key, float[].class, defValue);
    }

    public void putFloatArray(String key, float[] value) {
        this.putObject(key, value);
    }

    public int getInt(String key, int defValue) {
        return this.getObject(key, Integer.class, defValue);
    }

    public void putInt(String key, int value) {
        this.putObject(key, value);
    }

    public int[] getIntArray(String key, int[] defValue) {
        return this.getObject(key, int[].class, defValue);
    }

    public void putIntArray(String key, int[] value) {
        this.putObject(key, value);
    }

    public double getDouble(String key, double defValue) {
        return this.getObject(key, Double.class, defValue);
    }

    public void putDouble(String key, double value) {
        this.putObject(key, value);
    }

    public double[] getDoubleArray(String key, double[] defValue) {
        return this.getObject(key, double[].class, defValue);
    }

    public void putDoubleArray(String key, double[] value) {
        this.putObject(key, value);
    }

    public long getLong(String key, long defValue) {
        return this.getObject(key, Long.class, defValue);
    }

    public void putLong(String key, long value) {
        this.putObject(key, value);
    }

    public long[] getLongArray(String key, long[] defValue) {
        return this.getObject(key, long[].class, defValue);
    }

    public void putLongArray(String key, long[] value) {
        this.putObject(key, value);
    }

    public String getString(String key, String defValue) {
        return this.getObject(key, String.class, defValue);
    }

    public void putString(String key, String value) {
        this.putObject(key, value);
    }

    public String[] getStringArray(String key, String[] defValue) {
        return this.getObject(key, String[].class, defValue);
    }

    public void putStringArray(String key, String[] value) {
        this.putObject(key, value);
    }
}

