/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import site.iway.javahelpers.FileSystemHelper;
import site.iway.javahelpers.HttpConnector;
import site.iway.javahelpers.StringHelper;

public class HttpFileDownloader
extends HttpConnector {
    private String mFilePath;
    private File mFile;
    private String mTempFilePath;
    private File mTempFile;
    private FileOutputStream mFileOutputStream;
    private boolean mOverwriteIfExisted;

    public HttpFileDownloader(String url, String file) {
        super(url);
        this.mFilePath = file;
        this.mFile = new File(this.mFilePath);
        this.mTempFilePath = this.mFilePath + "-" + StringHelper.random(8);
        this.mTempFile = new File(this.mTempFilePath);
    }

    public boolean getOverwriteIfExisted() {
        return this.mOverwriteIfExisted;
    }

    public void setOverwriteIfExisted(boolean overwriteIfExisted) {
        this.mOverwriteIfExisted = overwriteIfExisted;
    }

    @Override
    public void onPrepare() throws Exception {
        if (!FileSystemHelper.createDirectory(this.mTempFile.getParentFile())) {
            throw new RuntimeException("Create store directory failed.");
        }
        this.mFileOutputStream = new FileOutputStream(this.mTempFilePath);
    }

    @Override
    public void onDataDownloaded(byte[] data, int startIndex, int count) throws Exception {
        this.mFileOutputStream.write(data, startIndex, count);
    }

    @Override
    public void onCanceled() throws Exception {
        throw new RuntimeException("Operation has been canceled.");
    }

    private void closeCurrentFileStream() {
        if (this.mFileOutputStream != null) {
            try {
                this.mFileOutputStream.close();
                this.mFileOutputStream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteTempFile() {
        if (this.mTempFile != null && !this.mTempFile.delete()) {
            this.mTempFile.deleteOnExit();
        }
    }

    private void renameTempFile() throws Exception {
        boolean result;
        if (this.mFile.exists()) {
            if (this.mOverwriteIfExisted) {
                result = this.mFile.delete();
                if (!result) {
                    throw new IOException("Delete " + this.mFilePath + " failed.");
                }
            } else {
                throw new IOException(this.mFilePath + " already existed, try setOverwriteIfExisted(true) ?");
            }
        }
        if (!(result = this.mTempFile.renameTo(this.mFile))) {
            throw new IOException("Rename file " + this.mTempFile + " to " + this.mFilePath + " failed.");
        }
    }

    @Override
    public void onFinish() throws Exception {
        this.closeCurrentFileStream();
        this.renameTempFile();
    }

    @Override
    public void onError(Exception e) {
        this.closeCurrentFileStream();
        this.deleteTempFile();
    }
}

