/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpConnector
extends Thread {
    private String mUrlString;
    private String mUrlStringRedirect;
    private int mBufferSize;
    private volatile long mContentLength = 0L;
    private volatile long mDownloadedLength = 0L;
    private volatile boolean mIsCanceled = false;

    public HttpConnector(String url, int bufferSize) {
        if (url == null) {
            throw new NullPointerException("Parameter url can not be null.");
        }
        if (bufferSize <= 0) {
            throw new RuntimeException("Parameter bufferSize is not valid.");
        }
        this.mUrlString = url;
        this.mBufferSize = bufferSize;
    }

    public HttpConnector(String url) {
        this(url, 8192);
    }

    public long getContentLength() {
        return this.mContentLength;
    }

    public long getDownloadedLength() {
        return this.mDownloadedLength;
    }

    protected void onPrepare() throws Exception {
    }

    protected HttpURLConnection createConnection(boolean isRetry) throws Exception {
        URL url = new URL(isRetry ? this.mUrlStringRedirect : this.mUrlString);
        return (HttpURLConnection)url.openConnection();
    }

    protected void onStartConnect(HttpURLConnection connection) throws Exception {
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(20000);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestProperty("Accept-Encoding", "identity");
    }

    protected void onConnected(HttpURLConnection connection) throws Exception {
    }

    protected boolean willRetryConnect(HttpURLConnection connection) throws Exception {
        boolean willRedirect;
        int responseCode = connection.getResponseCode();
        boolean bl = willRedirect = responseCode == 301 || responseCode == 302;
        if (willRedirect) {
            this.mUrlStringRedirect = connection.getHeaderField("Location");
        }
        return willRedirect;
    }

    protected void onDataDownloaded(byte[] buffer, int startIndex, int count) throws Exception {
    }

    protected void onCanceled() throws Exception {
    }

    protected void onFinish() throws Exception {
    }

    protected void onError(Exception e) {
    }

    protected void onFinally() {
    }

    public void cancel() {
        this.mIsCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        try {
            this.onPrepare();
            connection = this.createConnection(false);
            this.onStartConnect(connection);
            connection.connect();
            this.onConnected(connection);
            while (this.willRetryConnect(connection)) {
                connection.disconnect();
                connection = this.createConnection(true);
                this.onStartConnect(connection);
                connection.connect();
                this.onConnected(connection);
            }
            if (connection.getDoInput()) {
                this.mContentLength = connection.getContentLength();
                this.mDownloadedLength = 0L;
                InputStream inputStream = connection.getInputStream();
                byte[] buffer = new byte[this.mBufferSize];
                long totalReadCount = 0L;
                while (true) {
                    int readCount = inputStream.read(buffer);
                    if (this.mIsCanceled) {
                        this.onCanceled();
                        break;
                    }
                    if (readCount > 0) {
                        this.onDataDownloaded(buffer, 0, readCount);
                        this.mDownloadedLength = totalReadCount += (long)readCount;
                        continue;
                    }
                    if (readCount != 0) break;
                    HttpConnector.sleep(100L);
                }
            }
            this.onFinish();
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            this.onFinally();
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

