/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import site.iway.javahelpers.BitConverter;

public class HanziPinyinHelper {
    private static int HANZI_COUNT = 6727;
    private static int PINYIN_COUNT = 629;
    private static char[] mHanziArray;
    private static short[] mRefsArray;
    private static String[] mPinyinArray;

    private static void initialize(InputStream isHanziRef, InputStream isPinyin) throws IOException {
        mHanziArray = new char[HANZI_COUNT];
        mRefsArray = new short[HANZI_COUNT];
        mPinyinArray = new String[PINYIN_COUNT];
        byte[] buffer = new byte[32768];
        int startIndex = 0;
        int readCount = isHanziRef.read(buffer);
        while (readCount > -1) {
            readCount = isHanziRef.read(buffer, startIndex += readCount, buffer.length - startIndex);
        }
        isHanziRef.close();
        for (int i = 0; i < HANZI_COUNT; ++i) {
            HanziPinyinHelper.mHanziArray[i] = BitConverter.getChar(buffer, i * 4);
            HanziPinyinHelper.mRefsArray[i] = BitConverter.getShort(buffer, i * 4 + 2);
        }
        InputStreamReader pinyinReader = new InputStreamReader(isPinyin, Charset.forName("UTF-8"));
        BufferedReader pinyinBufferedReader = new BufferedReader(pinyinReader, 16384);
        for (int i = 0; i < PINYIN_COUNT; ++i) {
            HanziPinyinHelper.mPinyinArray[i] = pinyinBufferedReader.readLine();
        }
        pinyinBufferedReader.close();
    }

    public static void initialize() {
        try {
            InputStream isHanziRef = HanziPinyinHelper.class.getResourceAsStream("/hanzi_ref.dat");
            InputStream isPinyin = HanziPinyinHelper.class.getResourceAsStream("/pinyin.dat");
            HanziPinyinHelper.initialize(isHanziRef, isPinyin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int getRefIndex(char hanzi) {
        int lo = 0;
        int hi = HANZI_COUNT - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValCmp = mHanziArray[mid] - hanzi;
            if (midValCmp < 0) {
                lo = mid + 1;
                continue;
            }
            if (midValCmp > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static String getPinyin(char c) {
        int refIndex = HanziPinyinHelper.getRefIndex(c);
        if (refIndex > -1) {
            short pinyinIndex = mRefsArray[refIndex];
            String pinyin = mPinyinArray[pinyinIndex];
            int emptyIndex = pinyin.indexOf(32);
            if (emptyIndex > -1) {
                pinyin = pinyin.substring(0, emptyIndex);
            }
            return pinyin;
        }
        return null;
    }

    public static String getAllPinyins(char c, char splitter) {
        short pinyinIndex;
        String pinyin;
        int refIndex = HanziPinyinHelper.getRefIndex(c);
        if (refIndex > -1 && (pinyin = mPinyinArray[pinyinIndex = mRefsArray[refIndex]]) != null) {
            if (splitter == ' ') {
                return pinyin;
            }
            return pinyin.replace(' ', splitter);
        }
        return null;
    }

    public static String[] getAllPinyins(char c) {
        String pinyin = HanziPinyinHelper.getPinyin(c);
        if (pinyin != null) {
            return pinyin.split(" ");
        }
        return null;
    }

    public static String getPinyin(String s) {
        StringBuilder builder = new StringBuilder();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            String pinyin = HanziPinyinHelper.getPinyin(c);
            builder.append(pinyin == null ? Character.valueOf(c) : pinyin);
        }
        return builder.toString();
    }

    public static boolean isHanzi(char c) {
        return HanziPinyinHelper.getRefIndex(c) > -1;
    }

    public static void freeMemory() {
        mHanziArray = null;
        mRefsArray = null;
        mPinyinArray = null;
    }
}

