/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class FolderScanner
extends Thread {
    private ArrayList<String> mExtensions = new ArrayList();
    private ArrayList<File> mFolders = new ArrayList();
    private boolean mIsCanceled;

    public void addExtensions(String ... extensions) {
        this.mExtensions.addAll(Arrays.asList(extensions));
    }

    public void addExtensions(List<String> extensions) {
        for (String extension : extensions) {
            this.mExtensions.add(extension);
        }
    }

    public void addFolders(File ... folders) {
        this.mFolders.addAll(Arrays.asList(folders));
    }

    public void addFolders(List<File> folders) {
        this.mFolders.addAll(folders);
    }

    protected void onStarted(File folder) {
    }

    protected void onEnterFolder(File folder) {
    }

    protected void onDetectFile(File file) {
    }

    protected void onSkipFile(File file) {
    }

    protected void onCompleted(File folder) {
    }

    protected void onAllCompleted() {
    }

    private boolean isFileValid(File file) {
        String name = file.getAbsolutePath();
        for (String ext : this.mExtensions) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return this.mExtensions.isEmpty();
    }

    private void scan(File root) {
        if (this.mIsCanceled) {
            return;
        }
        this.onEnterFolder(root);
        File[] contents = root.listFiles();
        if (contents == null) {
            return;
        }
        for (File file : contents) {
            if (this.mIsCanceled) {
                return;
            }
            if (file.isDirectory()) {
                this.scan(file);
                continue;
            }
            if (this.isFileValid(file)) {
                this.onDetectFile(file);
                continue;
            }
            this.onSkipFile(file);
        }
    }

    @Override
    public void run() {
        for (File folder : this.mFolders) {
            if (this.mIsCanceled) break;
            this.onStarted(folder);
            this.scan(folder);
            this.onCompleted(folder);
        }
        this.onAllCompleted();
    }

    public void cancel() {
        this.mIsCanceled = true;
    }
}

