/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.File;
import java.text.DecimalFormat;

@Deprecated
public class CacheCleaner {
    private String mCachePath;
    private CacheCleanerListener mListener;
    private volatile float mCacheSize;
    private volatile boolean mIsCanceled;
    private Thread mSizeComputer = new Thread(){

        private void addFileSizes(String path) {
            File root = new File(path);
            File[] files = root.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (CacheCleaner.this.mIsCanceled) {
                    return;
                }
                if (file.isFile()) {
                    CacheCleaner.this.mCacheSize = CacheCleaner.this.mCacheSize + (float)file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.addFileSizes(file.getAbsolutePath());
            }
        }

        @Override
        public void run() {
            CacheCleaner.this.mCacheSize = 0.0f;
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.Initialized);
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.BeginComputeSize);
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.ComputingSize);
            this.addFileSizes(CacheCleaner.this.mCachePath);
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.EndComputeSize);
            CacheCleaner.this.mSizeComputer = null;
        }
    };
    private Thread mCleaner = new Thread(){

        private void cleanDir(String path) {
            File root = new File(path);
            File[] files = root.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (CacheCleaner.this.mIsCanceled) {
                    return;
                }
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanDir(file.getAbsolutePath());
            }
        }

        @Override
        public void run() {
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.BeginClean);
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.Cleaning);
            this.cleanDir(CacheCleaner.this.mCachePath);
            CacheCleaner.this.mListener.onCacheCleanerStateChanged(CacheCleanerState.Finished);
            CacheCleaner.this.mCleaner = null;
        }
    };

    public CacheCleaner(String cachePath, CacheCleanerListener listener) {
        this.mCachePath = cachePath;
        this.mListener = listener;
    }

    public void beginComputeSize() {
        this.mSizeComputer.start();
    }

    public float getCacheSize() {
        return this.mCacheSize;
    }

    public String getCacheSizeFormatedK() {
        return new DecimalFormat("0.0").format(this.mCacheSize / 1024.0f);
    }

    public String getCacheSizeFormatedM() {
        return new DecimalFormat("0.0").format(this.mCacheSize / 1024.0f / 1024.0f);
    }

    public void beginClean() {
        this.mCleaner.start();
    }

    public void cancel() {
        this.mIsCanceled = true;
    }

    public static enum CacheCleanerState {
        Initialized,
        BeginComputeSize,
        ComputingSize,
        EndComputeSize,
        BeginClean,
        Cleaning,
        Finished;

    }

    public static interface CacheCleanerListener {
        public void onCacheCleanerStateChanged(CacheCleanerState var1);
    }
}

