/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

public class AutoExpandLongArray {
    private long[] mArray;
    private long[] mLong;
    private int mLength;

    public AutoExpandLongArray(int initSize) {
        this.mArray = new long[initSize];
        this.mLong = new long[1];
        this.mLength = 0;
    }

    public AutoExpandLongArray() {
        this(1024);
    }

    public void add(long[] data, int startIndex, int count) {
        int targetLength = this.mLength + count;
        if (targetLength >= this.mArray.length) {
            long[] newArray = new long[targetLength * 2];
            System.arraycopy(this.mArray, 0, newArray, 0, this.mLength);
            this.mArray = newArray;
        }
        System.arraycopy(data, startIndex, this.mArray, this.mLength, count);
        this.mLength += count;
    }

    public void add(long[] ls) {
        this.add(ls, 0, ls.length);
    }

    public void add(long l) {
        this.mLong[0] = l;
        this.add(this.mLong);
    }

    public long get(int index) {
        if (index > -1 && index < this.mLength) {
            return this.mArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void set(int index, long l) {
        if (index > -1 && index < this.mLength) {
            this.mArray[index] = l;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean has(long l) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mArray[i] != l) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mLength = 0;
    }

    public int size() {
        return this.mLength;
    }

    public long[] getOutArray() {
        long[] array = new long[this.mLength];
        System.arraycopy(this.mArray, 0, array, 0, this.mLength);
        return array;
    }

    public long[] getRawArray() {
        return this.mArray;
    }
}

