/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

public class AutoExpandIntArray {
    private int[] mArray;
    private int[] mInt;
    private int mLength;

    public AutoExpandIntArray(int initSize) {
        this.mArray = new int[initSize];
        this.mInt = new int[1];
        this.mLength = 0;
    }

    public AutoExpandIntArray() {
        this(2048);
    }

    public void add(int[] data, int startIndex, int count) {
        int targetLength = this.mLength + count;
        if (targetLength >= this.mArray.length) {
            int[] newArray = new int[targetLength * 2];
            System.arraycopy(this.mArray, 0, newArray, 0, this.mLength);
            this.mArray = newArray;
        }
        System.arraycopy(data, startIndex, this.mArray, this.mLength, count);
        this.mLength += count;
    }

    public void add(int[] is) {
        this.add(is, 0, is.length);
    }

    public void add(int i) {
        this.mInt[0] = i;
        this.add(this.mInt);
    }

    public int get(int index) {
        if (index > -1 && index < this.mLength) {
            return this.mArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void set(int index, int i) {
        if (index > -1 && index < this.mLength) {
            this.mArray[index] = i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean has(int i) {
        for (int j = 0; j < this.mLength; ++j) {
            if (this.mArray[j] != i) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mLength = 0;
    }

    public int size() {
        return this.mLength;
    }

    public int[] getOutArray() {
        int[] array = new int[this.mLength];
        System.arraycopy(this.mArray, 0, array, 0, this.mLength);
        return array;
    }

    public int[] getRawArray() {
        return this.mArray;
    }
}

