/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

public class AutoExpandByteArray {
    private byte[] mArray;
    private byte[] mByte;
    private int mLength;

    public AutoExpandByteArray(int initSize) {
        this.mArray = new byte[initSize];
        this.mByte = new byte[1];
        this.mLength = 0;
    }

    public AutoExpandByteArray() {
        this(8192);
    }

    public void add(byte[] data, int startIndex, int count) {
        int targetLength = this.mLength + count;
        if (targetLength >= this.mArray.length) {
            byte[] newArray = new byte[targetLength * 2];
            System.arraycopy(this.mArray, 0, newArray, 0, this.mLength);
            this.mArray = newArray;
        }
        System.arraycopy(data, startIndex, this.mArray, this.mLength, count);
        this.mLength += count;
    }

    public void add(byte[] bs) {
        this.add(bs, 0, bs.length);
    }

    public void add(byte b) {
        this.mByte[0] = b;
        this.add(this.mByte);
    }

    public byte get(int index) {
        if (index > -1 && index < this.mLength) {
            return this.mArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void set(int index, byte b) {
        if (index > -1 && index < this.mLength) {
            this.mArray[index] = b;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean has(byte b) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mArray[i] != b) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.mLength = 0;
    }

    public int size() {
        return this.mLength;
    }

    public byte[] getOutArray() {
        byte[] array = new byte[this.mLength];
        System.arraycopy(this.mArray, 0, array, 0, this.mLength);
        return array;
    }

    public byte[] getRawArray() {
        return this.mArray;
    }
}

