/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;

public class AddressHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Country loadChina() {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = AddressHelper.class.getResourceAsStream("/china.dat");
            inputStreamReader = new InputStreamReader(inputStream);
            Gson gson = new Gson();
            Country country = (Country)gson.fromJson((Reader)inputStreamReader, Country.class);
            return country;
        }
        catch (Exception e) {
            Country country = null;
            return country;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class Country
    extends AddressInfo {
        private static final long serialVersionUID = 1L;
        public List<Province> provinces;

        public Province findProvince(String name) {
            for (Province province : this.provinces) {
                if (!province.name.contains(name)) continue;
                return province;
            }
            return null;
        }
    }

    public static class Province
    extends AddressInfo {
        private static final long serialVersionUID = 1L;
        public List<City> cities;

        public City findCity(String name) {
            for (City city : this.cities) {
                if (!city.name.contains(name)) continue;
                return city;
            }
            return null;
        }
    }

    public static class City
    extends AddressInfo {
        private static final long serialVersionUID = 1L;
        public List<Area> areas;

        public Area findArea(String name) {
            for (Area area : this.areas) {
                if (!area.name.contains(name)) continue;
                return area;
            }
            return null;
        }
    }

    public static class Area
    extends AddressInfo {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class AddressInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
    }
}

