/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.IBinder;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

public class WindowHelper {
    public static boolean makeTranslucent(Activity activity, boolean status, boolean navigation) {
        if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            if (status) {
                window.addFlags(0x4000000);
            }
            if (navigation) {
                window.addFlags(0x8000000);
            }
            return true;
        }
        return false;
    }

    public static boolean makeTranslucent(Activity activity) {
        return WindowHelper.makeTranslucent(activity, true, true);
    }

    public static int getWindowRotationDegrees(Activity activity) {
        WindowManager windowManager = activity.getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        int rotation = display.getRotation();
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Resources resources = context.getResources();
        return resources.getDisplayMetrics();
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics = WindowHelper.getDisplayMetrics(context);
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics displayMetrics = WindowHelper.getDisplayMetrics(context);
        return displayMetrics.heightPixels;
    }

    public static boolean showSoftInput(View view) {
        Context context = view.getContext();
        Object service = context.getSystemService("input_method");
        InputMethodManager inputMethodManager = (InputMethodManager)service;
        return inputMethodManager.showSoftInput(view, 0);
    }

    public static boolean hideSoftInput(View view) {
        Context context = view.getContext();
        Object service = context.getSystemService("input_method");
        InputMethodManager inputMethodManager = (InputMethodManager)service;
        IBinder windowToken = view.getWindowToken();
        return inputMethodManager.hideSoftInputFromWindow(windowToken, 0);
    }
}

