/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import site.iway.androidhelpers.R;

public class ViewSwapper
extends FrameLayout {
    private boolean mAttachedToWindow;
    private Animation mInAnimation;
    private Animation mOutAnimation;
    private int mDisplayedChild;
    protected boolean mUserInteractEnabled = true;

    public ViewSwapper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttr(context, attrs);
    }

    public ViewSwapper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttr(context, attrs);
    }

    public ViewSwapper(Context context) {
        super(context);
        this.resolveAttr(context, null);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
    }

    protected void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        super.onDetachedFromWindow();
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.setDisplayedChild(this.mDisplayedChild, false);
    }

    public Animation getInAnimation() {
        return this.mInAnimation;
    }

    public void setInAnimation(Animation animation) {
        this.mInAnimation = animation;
    }

    public void setInAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setInAnimation(animation);
        }
    }

    public Animation getOutAnimation() {
        return this.mOutAnimation;
    }

    public void setOutAnimation(Animation animation) {
        this.mOutAnimation = animation;
    }

    public void setOutAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setOutAnimation(animation);
        }
    }

    private void resolveAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewSwapper);
        this.mDisplayedChild = a.getInt(R.styleable.ViewSwapper_displayedChild, 0);
        this.setInAnimation(a.getResourceId(R.styleable.ViewSwapper_inAnimation, 0));
        this.setOutAnimation(a.getResourceId(R.styleable.ViewSwapper_outAnimation, 0));
        a.recycle();
        this.setMeasureAllChildren(true);
    }

    public int getDisplayedChild() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int visibility = child.getVisibility();
            if (visibility != 0) continue;
            return i;
        }
        return -1;
    }

    public void setDisplayedChild(int index, boolean animated) {
        this.mDisplayedChild = index;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            child.clearAnimation();
            int visibility = child.getVisibility();
            if (i == index) {
                if (visibility == 0) continue;
                child.setVisibility(0);
                if (!this.mAttachedToWindow || this.mInAnimation == null || !animated) continue;
                child.startAnimation(this.mInAnimation);
                continue;
            }
            if (visibility != 0) continue;
            child.setVisibility(8);
            if (!this.mAttachedToWindow || this.mOutAnimation == null || !animated) continue;
            child.startAnimation(this.mOutAnimation);
        }
    }

    public void setDisplayedChild(int index) {
        this.setDisplayedChild(index, true);
    }

    public void disableUserInteract() {
        this.mUserInteractEnabled = false;
    }

    public void enableUserInteract() {
        this.mUserInteractEnabled = true;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mUserInteractEnabled) {
            return super.dispatchTouchEvent(ev);
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                return false;
            }
        }
        ev.setAction(3);
        boolean superResult = super.dispatchTouchEvent(ev);
        ev.setAction(action);
        return false;
    }
}

